var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function scan(project, acc) {
    return this.lift(new ScanOperator(project));
}
exports.default = scan;
var ScanOperator = (function (_super) {
    __extends(ScanOperator, _super);
    function ScanOperator(project, acc) {
        _super.call(this);
        this.acc = acc;
        this.project = project;
    }
    ScanOperator.prototype.call = function (observer) {
        return new ScanSubscriber(observer, this.project, this.acc);
    };
    return ScanOperator;
})(Operator_1.default);
exports.ScanOperator = ScanOperator;
var ScanSubscriber = (function (_super) {
    __extends(ScanSubscriber, _super);
    function ScanSubscriber(destination, project, acc) {
        _super.call(this, destination);
        this.hasValue = false;
        this.acc = acc;
        this.project = project;
        this.hasSeed = typeof acc !== "undefined";
    }
    ScanSubscriber.prototype._next = function (x) {
        if (this.hasValue || (this.hasValue = this.hasSeed)) {
            var result = tryCatch_1.default(this.project).call(this, this.acc, x);
            if (result === errorObject_1.errorObject) {
                this.destination.error(errorObject_1.errorObject.e);
            }
            else {
                this.destination.next(this.acc = result);
            }
        }
        else {
            return this.destination.next((this.hasValue = true) && (this.acc = x));
        }
    };
    ScanSubscriber.prototype._complete = function () {
        if (!this.hasValue && this.hasSeed) {
            this.destination.next(this.acc);
        }
        this.destination.complete();
    };
    return ScanSubscriber;
})(Subscriber_1.default);
exports.ScanSubscriber = ScanSubscriber;
