var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
function skip(total) {
    return this.lift(new SkipOperator(total));
}
exports.default = skip;
var SkipOperator = (function (_super) {
    __extends(SkipOperator, _super);
    function SkipOperator(total) {
        _super.call(this);
        this.total = total;
    }
    SkipOperator.prototype.call = function (observer) {
        return new SkipSubscriber(observer, this.total);
    };
    return SkipOperator;
})(Operator_1.default);
exports.SkipOperator = SkipOperator;
var SkipSubscriber = (function (_super) {
    __extends(SkipSubscriber, _super);
    function SkipSubscriber(destination, total) {
        _super.call(this, destination);
        this.count = 0;
        this.total = total;
    }
    SkipSubscriber.prototype._next = function (x) {
        if (++this.count > this.total) {
            this.destination.next(x);
        }
    };
    return SkipSubscriber;
})(Subscriber_1.default);
exports.SkipSubscriber = SkipSubscriber;
