var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
function take(total) {
    return this.lift(new TakeOperator(total));
}
exports.default = take;
var TakeOperator = (function (_super) {
    __extends(TakeOperator, _super);
    function TakeOperator(total) {
        _super.call(this);
        this.total = total;
    }
    TakeOperator.prototype.call = function (observer) {
        return new TakeSubscriber(observer, this.total);
    };
    return TakeOperator;
})(Operator_1.default);
exports.TakeOperator = TakeOperator;
var TakeSubscriber = (function (_super) {
    __extends(TakeSubscriber, _super);
    function TakeSubscriber(destination, total) {
        _super.call(this, destination);
        this.count = 0;
        this.total = total;
    }
    TakeSubscriber.prototype._next = function (x) {
        if (++this.count <= this.total) {
            this.destination.next(x);
        }
        else {
            this.destination.complete();
        }
    };
    return TakeSubscriber;
})(Subscriber_1.default);
exports.TakeSubscriber = TakeSubscriber;
