var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
function takeUntil(observable) {
    return this.lift(new TakeUntilOperator(observable));
}
exports.default = takeUntil;
var TakeUntilOperator = (function (_super) {
    __extends(TakeUntilOperator, _super);
    function TakeUntilOperator(observable) {
        _super.call(this);
        this.observable = observable;
    }
    TakeUntilOperator.prototype.call = function (observer) {
        return new TakeUntilSubscriber(observer, this.observable);
    };
    return TakeUntilOperator;
})(Operator_1.default);
exports.TakeUntilOperator = TakeUntilOperator;
var TakeUntilSubscriber = (function (_super) {
    __extends(TakeUntilSubscriber, _super);
    function TakeUntilSubscriber(destination, observable) {
        _super.call(this, destination);
        this.add(observable.subscribe(new TakeUntilInnerSubscriber(destination)));
    }
    return TakeUntilSubscriber;
})(Subscriber_1.default);
exports.TakeUntilSubscriber = TakeUntilSubscriber;
var TakeUntilInnerSubscriber = (function (_super) {
    __extends(TakeUntilInnerSubscriber, _super);
    function TakeUntilInnerSubscriber(destination) {
        _super.call(this, destination);
    }
    TakeUntilInnerSubscriber.prototype._next = function () {
        this.destination.complete();
    };
    TakeUntilInnerSubscriber.prototype._error = function (e) {
        this.destination.error(e);
    };
    TakeUntilInnerSubscriber.prototype._complete = function () {
    };
    return TakeUntilInnerSubscriber;
})(Subscriber_1.default);
exports.TakeUntilInnerSubscriber = TakeUntilInnerSubscriber;
