var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Operator_1 = require('../Operator');
var Subscriber_1 = require('../Subscriber');
var ArrayObservable_1 = require('../observables/ArrayObservable');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function zip() {
    var xs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        xs[_i - 0] = arguments[_i];
    }
    var project = xs[xs.length - 1];
    if (typeof project === "function") {
        xs.pop();
    }
    if (typeof this.subscribe === "function") {
        return new ArrayObservable_1.default([this].concat(xs)).lift(new ZipOperator(project));
    }
    return new ArrayObservable_1.default(xs).lift(new ZipOperator(project));
}
exports.default = zip;
var ZipOperator = (function (_super) {
    __extends(ZipOperator, _super);
    function ZipOperator(project) {
        _super.call(this);
        this.project = project;
    }
    ZipOperator.prototype.call = function (observer) {
        return new ZipSubscriber(observer, this.project);
    };
    return ZipOperator;
})(Operator_1.default);
exports.ZipOperator = ZipOperator;
var ZipSubscriber = (function (_super) {
    __extends(ZipSubscriber, _super);
    function ZipSubscriber(destination, project, values) {
        if (values === void 0) { values = Object.create(null); }
        _super.call(this, destination);
        this.active = 0;
        this.observables = [];
        this.limit = Number.POSITIVE_INFINITY;
        this.project = (typeof project === "function") ? project : null;
        this.values = values;
    }
    ZipSubscriber.prototype._next = function (observable) {
        this.observables.push(observable);
    };
    ZipSubscriber.prototype._complete = function () {
        var values = this.values;
        var observables = this.observables;
        var index = -1;
        var len = observables.length;
        this.active = len;
        while (++index < len) {
            this.add(this._subscribeInner(observables[index], values, index, len));
        }
    };
    ZipSubscriber.prototype._subscribeInner = function (observable, values, index, total) {
        return observable.subscribe(new ZipInnerSubscriber(this, values, index, total));
    };
    ZipSubscriber.prototype._innerComplete = function (innerSubscriber) {
        if ((this.active -= 1) === 0) {
            this.destination.complete();
        }
        else {
            this.limit = innerSubscriber.events;
        }
    };
    return ZipSubscriber;
})(Subscriber_1.default);
exports.ZipSubscriber = ZipSubscriber;
var ZipInnerSubscriber = (function (_super) {
    __extends(ZipInnerSubscriber, _super);
    function ZipInnerSubscriber(parent, values, index, total) {
        _super.call(this, parent.destination);
        this.events = 0;
        this.parent = parent;
        this.values = values;
        this.index = index;
        this.total = total;
    }
    ZipInnerSubscriber.prototype._next = function (x) {
        var parent = this.parent;
        var events = this.events;
        var limit = parent.limit;
        if (events >= limit) {
            this.destination.complete();
            return;
        }
        var index = this.index;
        var values = this.values;
        var zipped = values[events] || (values[events] = []);
        zipped[index] = [x];
        if (zipped.length === this.total && zipped.every(hasValue)) {
            this._projectNext(zipped, parent.project);
            values[events] = undefined;
        }
        this.events = events + 1;
    };
    ZipInnerSubscriber.prototype._projectNext = function (values, project) {
        if (project && typeof project === "function") {
            var result = tryCatch_1.default(project).apply(null, values.map(mapValue));
            if (result === errorObject_1.errorObject) {
                this.destination.error(errorObject_1.errorObject.e);
                return;
            }
            else {
                this.destination.next(result);
            }
        }
        else {
            this.destination.next(values.map(mapValue));
        }
    };
    ZipInnerSubscriber.prototype._complete = function () {
        this.parent._innerComplete(this);
    };
    return ZipInnerSubscriber;
})(Subscriber_1.default);
exports.ZipInnerSubscriber = ZipInnerSubscriber;
function mapValue(xs) { return xs[0]; }
exports.mapValue = mapValue;
function hasValue(xs) { return xs && xs.length === 1; }
exports.hasValue = hasValue;
