var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Observable_1 = require('../Observable');
var Subscriber_1 = require('../Subscriber');
var PromiseObservable_1 = require('./PromiseObservable');
var EmptyObservable_1 = require('./EmptyObservable');
var isPromise_1 = require('../util/isPromise');
var ForkJoinObservable = (function (_super) {
    __extends(ForkJoinObservable, _super);
    function ForkJoinObservable(sources) {
        _super.call(this);
        this.sources = sources;
    }
    ForkJoinObservable.create = function () {
        var sources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sources[_i - 0] = arguments[_i];
        }
        if (sources === null || sources.length === 0) {
            return new EmptyObservable_1.EmptyObservable();
        }
        return new ForkJoinObservable(sources);
    };
    ForkJoinObservable.prototype.getResultSelector = function () {
        var sources = this.sources;
        var resultSelector = sources[sources.length - 1];
        if (typeof resultSelector !== 'function') {
            return null;
        }
        this.sources.pop();
        return resultSelector;
    };
    ForkJoinObservable.prototype._subscribe = function (subscriber) {
        var resultSelector = this.getResultSelector();
        var sources = this.sources;
        var len = sources.length;
        var context = { completed: 0, total: len, values: emptyArray(len), selector: resultSelector };
        for (var i = 0; i < len; i++) {
            var source = sources[i];
            if (isPromise_1.isPromise(source)) {
                source = new PromiseObservable_1.PromiseObservable(source);
            }
            source.subscribe(new AllSubscriber(subscriber, i, context));
        }
    };
    return ForkJoinObservable;
})(Observable_1.Observable);
exports.ForkJoinObservable = ForkJoinObservable;
var AllSubscriber = (function (_super) {
    __extends(AllSubscriber, _super);
    function AllSubscriber(destination, index, context) {
        _super.call(this, destination);
        this.index = index;
        this.context = context;
        this._value = null;
    }
    AllSubscriber.prototype._next = function (value) {
        this._value = value;
    };
    AllSubscriber.prototype._complete = function () {
        var destination = this.destination;
        if (this._value == null) {
            destination.complete();
        }
        var context = this.context;
        context.completed++;
        context.values[this.index] = this._value;
        var values = context.values;
        if (context.completed !== values.length) {
            return;
        }
        if (values.every(hasValue)) {
            var value = context.selector ? context.selector.apply(this, values) :
                values;
            destination.next(value);
        }
        destination.complete();
    };
    return AllSubscriber;
})(Subscriber_1.Subscriber);
function hasValue(x) {
    return x !== null;
}
function emptyArray(len) {
    var arr = [];
    for (var i = 0; i < len; i++) {
        arr.push(null);
    }
    return arr;
}
//# sourceMappingURL=ForkJoinObservable.js.map