var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscriber_1 = require('../Subscriber');
var nextTick_1 = require('../schedulers/nextTick');
function throttle(delay, scheduler) {
    if (scheduler === void 0) { scheduler = nextTick_1.nextTick; }
    return this.lift(new ThrottleOperator(delay, scheduler));
}
exports.throttle = throttle;
var ThrottleOperator = (function () {
    function ThrottleOperator(delay, scheduler) {
        this.delay = delay;
        this.scheduler = scheduler;
    }
    ThrottleOperator.prototype.call = function (subscriber) {
        return new ThrottleSubscriber(subscriber, this.delay, this.scheduler);
    };
    return ThrottleOperator;
})();
var ThrottleSubscriber = (function (_super) {
    __extends(ThrottleSubscriber, _super);
    function ThrottleSubscriber(destination, delay, scheduler) {
        _super.call(this, destination);
        this.delay = delay;
        this.scheduler = scheduler;
    }
    ThrottleSubscriber.prototype._next = function (value) {
        if (!this.throttled) {
            this.add(this.throttled = this.scheduler.schedule(dispatchNext, this.delay, { value: value, subscriber: this }));
        }
    };
    ThrottleSubscriber.prototype.throttledNext = function (value) {
        this.clearThrottle();
        this.destination.next(value);
    };
    ThrottleSubscriber.prototype.clearThrottle = function () {
        var throttled = this.throttled;
        if (throttled) {
            throttled.unsubscribe();
            this.remove(throttled);
        }
    };
    return ThrottleSubscriber;
})(Subscriber_1.Subscriber);
function dispatchNext(_a) {
    var value = _a.value, subscriber = _a.subscriber;
    subscriber.throttledNext(value);
}
//# sourceMappingURL=throttle.js.map