var FastMap = (function () {
    function FastMap() {
        this.size = 0;
        this._values = {};
    }
    FastMap.prototype.delete = function (key) {
        this._values[key] = null;
        return true;
    };
    FastMap.prototype.set = function (key, value) {
        this._values[key] = value;
        return this;
    };
    FastMap.prototype.get = function (key) {
        return this._values[key];
    };
    FastMap.prototype.forEach = function (cb, thisArg) {
        var values = this._values;
        for (var key in values) {
            if (values.hasOwnProperty(key) && values[key] !== null) {
                cb.call(thisArg, values[key], key);
            }
        }
    };
    FastMap.prototype.clear = function () {
        this._values = {};
    };
    return FastMap;
})();
exports.FastMap = FastMap;
//# sourceMappingURL=FastMap.js.map