import { Observable } from '../Observable';
import { Subscriber } from '../Subscriber';
import { PromiseObservable } from './PromiseObservable';
import { EmptyObservable } from './EmptyObservable';
import { isPromise } from '../util/isPromise';
export class ForkJoinObservable extends Observable {
    constructor(sources) {
        super();
        this.sources = sources;
    }
    static create(...sources) {
        if (sources === null || sources.length === 0) {
            return new EmptyObservable();
        }
        return new ForkJoinObservable(sources);
    }
    getResultSelector() {
        const sources = this.sources;
        let resultSelector = sources[sources.length - 1];
        if (typeof resultSelector !== 'function') {
            return null;
        }
        this.sources.pop();
        return resultSelector;
    }
    _subscribe(subscriber) {
        let resultSelector = this.getResultSelector();
        const sources = this.sources;
        const len = sources.length;
        const context = { completed: 0, total: len, values: emptyArray(len), selector: resultSelector };
        for (let i = 0; i < len; i++) {
            let source = sources[i];
            if (isPromise(source)) {
                source = new PromiseObservable(source);
            }
            source.subscribe(new AllSubscriber(subscriber, i, context));
        }
    }
}
class AllSubscriber extends Subscriber {
    constructor(destination, index, context) {
        super(destination);
        this.index = index;
        this.context = context;
        this._value = null;
    }
    _next(value) {
        this._value = value;
    }
    _complete() {
        const destination = this.destination;
        if (this._value == null) {
            destination.complete();
        }
        const context = this.context;
        context.completed++;
        context.values[this.index] = this._value;
        const values = context.values;
        if (context.completed !== values.length) {
            return;
        }
        if (values.every(hasValue)) {
            let value = context.selector ? context.selector.apply(this, values) :
                values;
            destination.next(value);
        }
        destination.complete();
    }
}
function hasValue(x) {
    return x !== null;
}
function emptyArray(len) {
    let arr = [];
    for (let i = 0; i < len; i++) {
        arr.push(null);
    }
    return arr;
}
//# sourceMappingURL=ForkJoinObservable.js.map