import { Observable } from '../Observable';
import { nextTick } from '../schedulers/nextTick';
import { isNumeric } from '../util/isNumeric';
export class SubscribeOnObservable extends Observable {
    constructor(source, delayTime = 0, scheduler = nextTick) {
        super();
        this.source = source;
        this.delayTime = delayTime;
        this.scheduler = scheduler;
        if (!isNumeric(delayTime) || delayTime < 0) {
            this.delayTime = 0;
        }
        if (!scheduler || typeof scheduler.schedule !== 'function') {
            this.scheduler = nextTick;
        }
    }
    static create(source, delay = 0, scheduler = nextTick) {
        return new SubscribeOnObservable(source, delay, scheduler);
    }
    static dispatch({ source, subscriber }) {
        return source.subscribe(subscriber);
    }
    _subscribe(subscriber) {
        const delay = this.delayTime;
        const source = this.source;
        const scheduler = this.scheduler;
        subscriber.add(scheduler.schedule(SubscribeOnObservable.dispatch, delay, {
            source, subscriber
        }));
    }
}
//# sourceMappingURL=SubscribeOnObservable.js.map