import { Subscriber } from '../Subscriber';
import { tryCatch } from '../util/tryCatch';
import { errorObject } from '../util/errorObject';
export function scan(project, acc) {
    return this.lift(new ScanOperator(project, acc));
}
class ScanOperator {
    constructor(project, acc) {
        this.acc = acc;
        this.project = project;
    }
    call(subscriber) {
        return new ScanSubscriber(subscriber, this.project, this.acc);
    }
}
class ScanSubscriber extends Subscriber {
    constructor(destination, project, acc) {
        super(destination);
        this.accumulatorSet = false;
        this.acc = acc;
        this.project = project;
        this.accumulatorSet = typeof acc !== 'undefined';
    }
    get acc() {
        return this._acc;
    }
    set acc(value) {
        this.accumulatorSet = true;
        this._acc = value;
    }
    _next(x) {
        if (!this.accumulatorSet) {
            this.acc = x;
            this.destination.next(x);
        }
        else {
            const result = tryCatch(this.project).call(this, this.acc, x);
            if (result === errorObject) {
                this.destination.error(errorObject.e);
            }
            else {
                this.acc = result;
                this.destination.next(this.acc);
            }
        }
    }
}
//# sourceMappingURL=scan.js.map