import { Observable } from '../Observable';
import { ConnectableObservable } from '../observable/ConnectableObservable';
/**
 * Returns a ConnectableObservable, which is a variety of Observable that waits until its connect method is called
 * before it begins emitting items to those Observers that have subscribed to it.
 *
 * <img src="./img/publish.png" width="100%">
 *
 * @param {Function} Optional selector function which can use the multicasted source sequence as many times as needed,
 * without causing multiple subscriptions to the source sequence.
 * Subscribers to the given source will receive all notifications of the source from the time of the subscription on.
 * @return a ConnectableObservable that upon connection causes the source Observable to emit items to its Observers.
 * @method publish
 * @owner Observable
 */
export declare function publish<T>(this: Observable<T>): ConnectableObservable<T>;
export declare function publish<T>(this: Observable<T>, selector: selector<T>): Observable<T>;
export declare type selector<T> = (source: Observable<T>) => Observable<T>;
