/** PURE_IMPORTS_START tslib,_Scheduler PURE_IMPORTS_END */
import * as tslib_1 from "tslib";
import { Scheduler } from '../Scheduler';
var AsyncScheduler = /*@__PURE__*/ (function (_super) {
    tslib_1.__extends(AsyncScheduler, _super);
    function AsyncScheduler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.actions = [];
        /**
         * A flag to indicate whether the Scheduler is currently executing a batch of
         * queued actions.
         * @type {boolean}
         */
        _this.active = false;
        /**
         * An internal ID used to track the latest asynchronous task such as those
         * coming from `setTimeout`, `setInterval`, `requestAnimationFrame`, and
         * others.
         * @type {any}
         */
        _this.scheduled = undefined;
        return _this;
    }
    AsyncScheduler.prototype.flush = function (action) {
        var actions = this.actions;
        if (this.active) {
            actions.push(action);
            return;
        }
        var error;
        this.active = true;
        do {
            if (error = action.execute(action.state, action.delay)) {
                break;
            }
        } while (action = actions.shift()); // exhaust the scheduler queue
        this.active = false;
        if (error) {
            while (action = actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    };
    return AsyncScheduler;
}(Scheduler));
export { AsyncScheduler };
//# sourceMappingURL=AsyncScheduler.js.map
