/**
  @license
                                 Apache License
                         Version 2.0, January 2004
                      http://www.apache.org/licenses/

 TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

 1. Definitions.

    "License" shall mean the terms and conditions for use, reproduction,
    and distribution as defined by Sections 1 through 9 of this document.

    "Licensor" shall mean the copyright owner or entity authorized by
    the copyright owner that is granting the License.

    "Legal Entity" shall mean the union of the acting entity and all
    other entities that control, are controlled by, or are under common
    control with that entity. For the purposes of this definition,
    "control" means (i) the power, direct or indirect, to cause the
    direction or management of such entity, whether by contract or
    otherwise, or (ii) ownership of fifty percent (50%) or more of the
    outstanding shares, or (iii) beneficial ownership of such entity.

    "You" (or "Your") shall mean an individual or Legal Entity
    exercising permissions granted by this License.

    "Source" form shall mean the preferred form for making modifications,
    including but not limited to software source code, documentation
    source, and configuration files.

    "Object" form shall mean any form resulting from mechanical
    transformation or translation of a Source form, including but
    not limited to compiled object code, generated documentation,
    and conversions to other media types.

    "Work" shall mean the work of authorship, whether in Source or
    Object form, made available under the License, as indicated by a
    copyright notice that is included in or attached to the work
    (an example is provided in the Appendix below).

    "Derivative Works" shall mean any work, whether in Source or Object
    form, that is based on (or derived from) the Work and for which the
    editorial revisions, annotations, elaborations, or other modifications
    represent, as a whole, an original work of authorship. For the purposes
    of this License, Derivative Works shall not include works that remain
    separable from, or merely link (or bind by name) to the interfaces of,
    the Work and Derivative Works thereof.

    "Contribution" shall mean any work of authorship, including
    the original version of the Work and any modifications or additions
    to that Work or Derivative Works thereof, that is intentionally
    submitted to Licensor for inclusion in the Work by the copyright owner
    or by an individual or Legal Entity authorized to submit on behalf of
    the copyright owner. For the purposes of this definition, "submitted"
    means any form of electronic, verbal, or written communication sent
    to the Licensor or its representatives, including but not limited to
    communication on electronic mailing lists, source code control systems,
    and issue tracking systems that are managed by, or on behalf of, the
    Licensor for the purpose of discussing and improving the Work, but
    excluding communication that is conspicuously marked or otherwise
    designated in writing by the copyright owner as "Not a Contribution."

    "Contributor" shall mean Licensor and any individual or Legal Entity
    on behalf of whom a Contribution has been received by Licensor and
    subsequently incorporated within the Work.

 2. Grant of Copyright License. Subject to the terms and conditions of
    this License, each Contributor hereby grants to You a perpetual,
    worldwide, non-exclusive, no-charge, royalty-free, irrevocable
    copyright license to reproduce, prepare Derivative Works of,
    publicly display, publicly perform, sublicense, and distribute the
    Work and such Derivative Works in Source or Object form.

 3. Grant of Patent License. Subject to the terms and conditions of
    this License, each Contributor hereby grants to You a perpetual,
    worldwide, non-exclusive, no-charge, royalty-free, irrevocable
    (except as stated in this section) patent license to make, have made,
    use, offer to sell, sell, import, and otherwise transfer the Work,
    where such license applies only to those patent claims licensable
    by such Contributor that are necessarily infringed by their
    Contribution(s) alone or by combination of their Contribution(s)
    with the Work to which such Contribution(s) was submitted. If You
    institute patent litigation against any entity (including a
    cross-claim or counterclaim in a lawsuit) alleging that the Work
    or a Contribution incorporated within the Work constitutes direct
    or contributory patent infringement, then any patent licenses
    granted to You under this License for that Work shall terminate
    as of the date such litigation is filed.

 4. Redistribution. You may reproduce and distribute copies of the
    Work or Derivative Works thereof in any medium, with or without
    modifications, and in Source or Object form, provided that You
    meet the following conditions:

    (a) You must give any other recipients of the Work or
        Derivative Works a copy of this License; and

    (b) You must cause any modified files to carry prominent notices
        stating that You changed the files; and

    (c) You must retain, in the Source form of any Derivative Works
        that You distribute, all copyright, patent, trademark, and
        attribution notices from the Source form of the Work,
        excluding those notices that do not pertain to any part of
        the Derivative Works; and

    (d) If the Work includes a "NOTICE" text file as part of its
        distribution, then any Derivative Works that You distribute must
        include a readable copy of the attribution notices contained
        within such NOTICE file, excluding those notices that do not
        pertain to any part of the Derivative Works, in at least one
        of the following places: within a NOTICE text file distributed
        as part of the Derivative Works; within the Source form or
        documentation, if provided along with the Derivative Works; or,
        within a display generated by the Derivative Works, if and
        wherever such third-party notices normally appear. The contents
        of the NOTICE file are for informational purposes only and
        do not modify the License. You may add Your own attribution
        notices within Derivative Works that You distribute, alongside
        or as an addendum to the NOTICE text from the Work, provided
        that such additional attribution notices cannot be construed
        as modifying the License.

    You may add Your own copyright statement to Your modifications and
    may provide additional or different license terms and conditions
    for use, reproduction, or distribution of Your modifications, or
    for any such Derivative Works as a whole, provided Your use,
    reproduction, and distribution of the Work otherwise complies with
    the conditions stated in this License.

 5. Submission of Contributions. Unless You explicitly state otherwise,
    any Contribution intentionally submitted for inclusion in the Work
    by You to the Licensor shall be under the terms and conditions of
    this License, without any additional terms or conditions.
    Notwithstanding the above, nothing herein shall supersede or modify
    the terms of any separate license agreement you may have executed
    with Licensor regarding such Contributions.

 6. Trademarks. This License does not grant permission to use the trade
    names, trademarks, service marks, or product names of the Licensor,
    except as required for reasonable and customary use in describing the
    origin of the Work and reproducing the content of the NOTICE file.

 7. Disclaimer of Warranty. Unless required by applicable law or
    agreed to in writing, Licensor provides the Work (and each
    Contributor provides its Contributions) on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
    implied, including, without limitation, any warranties or conditions
    of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
    PARTICULAR PURPOSE. You are solely responsible for determining the
    appropriateness of using or redistributing the Work and assume any
    risks associated with Your exercise of permissions under this License.

 8. Limitation of Liability. In no event and under no legal theory,
    whether in tort (including negligence), contract, or otherwise,
    unless required by applicable law (such as deliberate and grossly
    negligent acts) or agreed to in writing, shall any Contributor be
    liable to You for damages, including any direct, indirect, special,
    incidental, or consequential damages of any character arising as a
    result of this License or out of the use or inability to use the
    Work (including but not limited to damages for loss of goodwill,
    work stoppage, computer failure or malfunction, or any and all
    other commercial damages or losses), even if such Contributor
    has been advised of the possibility of such damages.

 9. Accepting Warranty or Additional Liability. While redistributing
    the Work or Derivative Works thereof, You may choose to offer,
    and charge a fee for, acceptance of support, warranty, indemnity,
    or other liability obligations and/or rights consistent with this
    License. However, in accepting such obligations, You may act only
    on Your own behalf and on Your sole responsibility, not on behalf
    of any other Contributor, and only if You agree to indemnify,
    defend, and hold each Contributor harmless for any liability
    incurred by, or claims asserted against, such Contributor by reason
    of your accepting any such warranty or additional liability.

 END OF TERMS AND CONDITIONS

 APPENDIX: How to apply the Apache License to your work.

    To apply the Apache License to your work, attach the following
    boilerplate notice, with the fields enclosed by brackets "[]"
    replaced with your own identifying information. (Don't include
    the brackets!)  The text should be enclosed in the appropriate
    comment syntax for the file format. We also recommend that a
    file or class name and description of purpose be included on the
    same "printed page" as the copyright notice for easier
    identification within third-party archives.

 Copyright (c) 2015-2018 Google, Inc., Netflix, Inc., Microsoft Corp. and contributors

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 

 **/
/**
  @license
                                 Apache License
                         Version 2.0, January 2004
                      http://www.apache.org/licenses/

 TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

 1. Definitions.

    "License" shall mean the terms and conditions for use, reproduction,
    and distribution as defined by Sections 1 through 9 of this document.

    "Licensor" shall mean the copyright owner or entity authorized by
    the copyright owner that is granting the License.

    "Legal Entity" shall mean the union of the acting entity and all
    other entities that control, are controlled by, or are under common
    control with that entity. For the purposes of this definition,
    "control" means (i) the power, direct or indirect, to cause the
    direction or management of such entity, whether by contract or
    otherwise, or (ii) ownership of fifty percent (50%) or more of the
    outstanding shares, or (iii) beneficial ownership of such entity.

    "You" (or "Your") shall mean an individual or Legal Entity
    exercising permissions granted by this License.

    "Source" form shall mean the preferred form for making modifications,
    including but not limited to software source code, documentation
    source, and configuration files.

    "Object" form shall mean any form resulting from mechanical
    transformation or translation of a Source form, including but
    not limited to compiled object code, generated documentation,
    and conversions to other media types.

    "Work" shall mean the work of authorship, whether in Source or
    Object form, made available under the License, as indicated by a
    copyright notice that is included in or attached to the work
    (an example is provided in the Appendix below).

    "Derivative Works" shall mean any work, whether in Source or Object
    form, that is based on (or derived from) the Work and for which the
    editorial revisions, annotations, elaborations, or other modifications
    represent, as a whole, an original work of authorship. For the purposes
    of this License, Derivative Works shall not include works that remain
    separable from, or merely link (or bind by name) to the interfaces of,
    the Work and Derivative Works thereof.

    "Contribution" shall mean any work of authorship, including
    the original version of the Work and any modifications or additions
    to that Work or Derivative Works thereof, that is intentionally
    submitted to Licensor for inclusion in the Work by the copyright owner
    or by an individual or Legal Entity authorized to submit on behalf of
    the copyright owner. For the purposes of this definition, "submitted"
    means any form of electronic, verbal, or written communication sent
    to the Licensor or its representatives, including but not limited to
    communication on electronic mailing lists, source code control systems,
    and issue tracking systems that are managed by, or on behalf of, the
    Licensor for the purpose of discussing and improving the Work, but
    excluding communication that is conspicuously marked or otherwise
    designated in writing by the copyright owner as "Not a Contribution."

    "Contributor" shall mean Licensor and any individual or Legal Entity
    on behalf of whom a Contribution has been received by Licensor and
    subsequently incorporated within the Work.

 2. Grant of Copyright License. Subject to the terms and conditions of
    this License, each Contributor hereby grants to You a perpetual,
    worldwide, non-exclusive, no-charge, royalty-free, irrevocable
    copyright license to reproduce, prepare Derivative Works of,
    publicly display, publicly perform, sublicense, and distribute the
    Work and such Derivative Works in Source or Object form.

 3. Grant of Patent License. Subject to the terms and conditions of
    this License, each Contributor hereby grants to You a perpetual,
    worldwide, non-exclusive, no-charge, royalty-free, irrevocable
    (except as stated in this section) patent license to make, have made,
    use, offer to sell, sell, import, and otherwise transfer the Work,
    where such license applies only to those patent claims licensable
    by such Contributor that are necessarily infringed by their
    Contribution(s) alone or by combination of their Contribution(s)
    with the Work to which such Contribution(s) was submitted. If You
    institute patent litigation against any entity (including a
    cross-claim or counterclaim in a lawsuit) alleging that the Work
    or a Contribution incorporated within the Work constitutes direct
    or contributory patent infringement, then any patent licenses
    granted to You under this License for that Work shall terminate
    as of the date such litigation is filed.

 4. Redistribution. You may reproduce and distribute copies of the
    Work or Derivative Works thereof in any medium, with or without
    modifications, and in Source or Object form, provided that You
    meet the following conditions:

    (a) You must give any other recipients of the Work or
        Derivative Works a copy of this License; and

    (b) You must cause any modified files to carry prominent notices
        stating that You changed the files; and

    (c) You must retain, in the Source form of any Derivative Works
        that You distribute, all copyright, patent, trademark, and
        attribution notices from the Source form of the Work,
        excluding those notices that do not pertain to any part of
        the Derivative Works; and

    (d) If the Work includes a "NOTICE" text file as part of its
        distribution, then any Derivative Works that You distribute must
        include a readable copy of the attribution notices contained
        within such NOTICE file, excluding those notices that do not
        pertain to any part of the Derivative Works, in at least one
        of the following places: within a NOTICE text file distributed
        as part of the Derivative Works; within the Source form or
        documentation, if provided along with the Derivative Works; or,
        within a display generated by the Derivative Works, if and
        wherever such third-party notices normally appear. The contents
        of the NOTICE file are for informational purposes only and
        do not modify the License. You may add Your own attribution
        notices within Derivative Works that You distribute, alongside
        or as an addendum to the NOTICE text from the Work, provided
        that such additional attribution notices cannot be construed
        as modifying the License.

    You may add Your own copyright statement to Your modifications and
    may provide additional or different license terms and conditions
    for use, reproduction, or distribution of Your modifications, or
    for any such Derivative Works as a whole, provided Your use,
    reproduction, and distribution of the Work otherwise complies with
    the conditions stated in this License.

 5. Submission of Contributions. Unless You explicitly state otherwise,
    any Contribution intentionally submitted for inclusion in the Work
    by You to the Licensor shall be under the terms and conditions of
    this License, without any additional terms or conditions.
    Notwithstanding the above, nothing herein shall supersede or modify
    the terms of any separate license agreement you may have executed
    with Licensor regarding such Contributions.

 6. Trademarks. This License does not grant permission to use the trade
    names, trademarks, service marks, or product names of the Licensor,
    except as required for reasonable and customary use in describing the
    origin of the Work and reproducing the content of the NOTICE file.

 7. Disclaimer of Warranty. Unless required by applicable law or
    agreed to in writing, Licensor provides the Work (and each
    Contributor provides its Contributions) on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
    implied, including, without limitation, any warranties or conditions
    of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
    PARTICULAR PURPOSE. You are solely responsible for determining the
    appropriateness of using or redistributing the Work and assume any
    risks associated with Your exercise of permissions under this License.

 8. Limitation of Liability. In no event and under no legal theory,
    whether in tort (including negligence), contract, or otherwise,
    unless required by applicable law (such as deliberate and grossly
    negligent acts) or agreed to in writing, shall any Contributor be
    liable to You for damages, including any direct, indirect, special,
    incidental, or consequential damages of any character arising as a
    result of this License or out of the use or inability to use the
    Work (including but not limited to damages for loss of goodwill,
    work stoppage, computer failure or malfunction, or any and all
    other commercial damages or losses), even if such Contributor
    has been advised of the possibility of such damages.

 9. Accepting Warranty or Additional Liability. While redistributing
    the Work or Derivative Works thereof, You may choose to offer,
    and charge a fee for, acceptance of support, warranty, indemnity,
    or other liability obligations and/or rights consistent with this
    License. However, in accepting such obligations, You may act only
    on Your own behalf and on Your sole responsibility, not on behalf
    of any other Contributor, and only if You agree to indemnify,
    defend, and hold each Contributor harmless for any liability
    incurred by, or claims asserted against, such Contributor by reason
    of your accepting any such warranty or additional liability.

 END OF TERMS AND CONDITIONS

 APPENDIX: How to apply the Apache License to your work.

    To apply the Apache License to your work, attach the following
    boilerplate notice, with the fields enclosed by brackets "[]"
    replaced with your own identifying information. (Don't include
    the brackets!)  The text should be enclosed in the appropriate
    comment syntax for the file format. We also recommend that a
    file or class name and description of purpose be included on the
    same "printed page" as the copyright notice for easier
    identification within third-party archives.

 Copyright (c) 2015-2018 Google, Inc., Netflix, Inc., Microsoft Corp. and contributors

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 

 **/
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define('rxjs', ['exports'], factory) :
    (factory((global.rxjs = {})));
}(this, (function (exports) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    }

    function isFunction(x) {
        return typeof x === 'function';
    }

    function createErrorClass(createImpl) {
        var _super = function (instance) {
            Error.call(instance);
            instance.name = instance.constructor.name;
            instance.stack = new Error().stack;
        };
        var ctorFunc = createImpl(_super);
        ctorFunc.prototype = Object.create(Error.prototype);
        ctorFunc.prototype.constructor = ctorFunc;
        return ctorFunc;
    }

    var UnsubscriptionError = createErrorClass(function (_super) {
        return function UnsubscriptionError(errors) {
            _super(this);
            this.message = errors
                ? errors.length + " errors occurred during unsubscription:\n" + errors.map(function (err, i) { return i + 1 + ") " + err.toString(); }).join('\n  ')
                : '';
            this.name = 'UnsubscriptionError';
            this.errors = errors;
        };
    });

    function arrRemove(arr, item) {
        if (arr) {
            var index = arr.indexOf(item);
            0 <= index && arr.splice(index, 1);
        }
    }

    var Subscription = (function () {
        function Subscription(initialTeardown) {
            this.initialTeardown = initialTeardown;
            this.closed = false;
            this._parentage = null;
            this._teardowns = null;
        }
        Subscription.prototype.unsubscribe = function () {
            var errors;
            if (!this.closed) {
                this.closed = true;
                var _parentage = this._parentage;
                if (Array.isArray(_parentage)) {
                    for (var _i = 0, _parentage_1 = _parentage; _i < _parentage_1.length; _i++) {
                        var parent_1 = _parentage_1[_i];
                        parent_1.remove(this);
                    }
                }
                else {
                    _parentage === null || _parentage === void 0 ? void 0 : _parentage.remove(this);
                }
                var initialTeardown = this.initialTeardown;
                if (isFunction(initialTeardown)) {
                    try {
                        initialTeardown();
                    }
                    catch (e) {
                        errors = e instanceof UnsubscriptionError ? e.errors : [e];
                    }
                }
                var _teardowns = this._teardowns;
                if (_teardowns) {
                    this._teardowns = null;
                    for (var _a = 0, _teardowns_1 = _teardowns; _a < _teardowns_1.length; _a++) {
                        var teardown_1 = _teardowns_1[_a];
                        try {
                            execTeardown(teardown_1);
                        }
                        catch (err) {
                            errors = errors !== null && errors !== void 0 ? errors : [];
                            if (err instanceof UnsubscriptionError) {
                                errors = __spreadArrays(errors, err.errors);
                            }
                            else {
                                errors.push(err);
                            }
                        }
                    }
                }
                if (errors) {
                    throw new UnsubscriptionError(errors);
                }
            }
        };
        Subscription.prototype.add = function (teardown) {
            var _a;
            if (teardown && teardown !== this) {
                if (this.closed) {
                    execTeardown(teardown);
                }
                else {
                    if (teardown instanceof Subscription) {
                        if (teardown.closed || teardown._hasParent(this)) {
                            return;
                        }
                        teardown._addParent(this);
                    }
                    (this._teardowns = (_a = this._teardowns) !== null && _a !== void 0 ? _a : []).push(teardown);
                }
            }
        };
        Subscription.prototype._hasParent = function (parent) {
            var _parentage = this._parentage;
            return _parentage === parent || (Array.isArray(_parentage) && _parentage.includes(parent));
        };
        Subscription.prototype._addParent = function (parent) {
            var _parentage = this._parentage;
            this._parentage = Array.isArray(_parentage) ? (_parentage.push(parent), _parentage) : _parentage ? [_parentage, parent] : parent;
        };
        Subscription.prototype._removeParent = function (parent) {
            var _parentage = this._parentage;
            if (_parentage === parent) {
                this._parentage = null;
            }
            else if (Array.isArray(_parentage)) {
                arrRemove(_parentage, parent);
            }
        };
        Subscription.prototype.remove = function (teardown) {
            var _teardowns = this._teardowns;
            _teardowns && arrRemove(_teardowns, teardown);
            if (teardown instanceof Subscription) {
                teardown._removeParent(this);
            }
        };
        Subscription.EMPTY = (function (empty) {
            empty.closed = true;
            return empty;
        })(new Subscription());
        return Subscription;
    }());
    var EMPTY_SUBSCRIPTION = Subscription.EMPTY;
    function isSubscription(value) {
        return (value instanceof Subscription ||
            (value &&
                'closed' in value &&
                typeof value.remove === 'function' &&
                typeof value.add === 'function' &&
                typeof value.unsubscribe === 'function'));
    }
    function execTeardown(teardown) {
        if (typeof teardown === 'function') {
            teardown();
        }
        else {
            teardown.unsubscribe();
        }
    }

    var config = {
        onUnhandledError: null,
        Promise: undefined,
        useDeprecatedSynchronousErrorHandling: false,
        useDeprecatedNextContext: false,
    };

    function reportUnhandledError(err) {
        setTimeout(function () {
            var onUnhandledError = config.onUnhandledError;
            if (onUnhandledError) {
                onUnhandledError(err);
            }
            else {
                throw err;
            }
        });
    }

    function noop() { }

    var Subscriber = (function (_super) {
        __extends(Subscriber, _super);
        function Subscriber(destination) {
            var _this = _super.call(this) || this;
            _this.isStopped = false;
            if (destination) {
                _this.destination = destination;
                if (isSubscription(destination)) {
                    destination.add(_this);
                }
            }
            else {
                _this.destination = EMPTY_OBSERVER;
            }
            return _this;
        }
        Subscriber.create = function (next, error, complete) {
            return new SafeSubscriber(next, error, complete);
        };
        Subscriber.prototype.next = function (value) {
            if (!this.isStopped) {
                this._next(value);
            }
        };
        Subscriber.prototype.error = function (err) {
            if (!this.isStopped) {
                this.isStopped = true;
                this._error(err);
            }
        };
        Subscriber.prototype.complete = function () {
            if (!this.isStopped) {
                this.isStopped = true;
                this._complete();
            }
        };
        Subscriber.prototype.unsubscribe = function () {
            if (!this.closed) {
                this.isStopped = true;
                _super.prototype.unsubscribe.call(this);
            }
        };
        Subscriber.prototype._next = function (value) {
            this.destination.next(value);
        };
        Subscriber.prototype._error = function (err) {
            this.destination.error(err);
            this.unsubscribe();
        };
        Subscriber.prototype._complete = function () {
            this.destination.complete();
            this.unsubscribe();
        };
        return Subscriber;
    }(Subscription));
    var SafeSubscriber = (function (_super) {
        __extends(SafeSubscriber, _super);
        function SafeSubscriber(observerOrNext, error, complete) {
            var _this = _super.call(this) || this;
            _this.destination = EMPTY_OBSERVER;
            if ((observerOrNext || error || complete) && observerOrNext !== EMPTY_OBSERVER) {
                var next = void 0;
                if (isFunction(observerOrNext)) {
                    next = observerOrNext;
                }
                else if (observerOrNext) {
                    (next = observerOrNext.next, error = observerOrNext.error, complete = observerOrNext.complete);
                    var context_1;
                    if (_this && config.useDeprecatedNextContext) {
                        context_1 = Object.create(observerOrNext);
                        context_1.unsubscribe = function () { return _this.unsubscribe(); };
                    }
                    else {
                        context_1 = observerOrNext;
                    }
                    next = next === null || next === void 0 ? void 0 : next.bind(context_1);
                    error = error === null || error === void 0 ? void 0 : error.bind(context_1);
                    complete = complete === null || complete === void 0 ? void 0 : complete.bind(context_1);
                }
                _this.destination = {
                    next: next || noop,
                    error: error || defaultErrorHandler,
                    complete: complete || noop,
                };
            }
            return _this;
        }
        return SafeSubscriber;
    }(Subscriber));
    function defaultErrorHandler(err) {
        if (config.useDeprecatedSynchronousErrorHandling) {
            throw err;
        }
        reportUnhandledError(err);
    }
    var EMPTY_OBSERVER = {
        closed: true,
        next: noop,
        error: defaultErrorHandler,
        complete: noop,
    };

    var observable = (function () { return typeof Symbol === 'function' && Symbol.observable || '@@observable'; })();

    function identity(x) {
        return x;
    }

    function pipe() {
        var fns = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            fns[_i] = arguments[_i];
        }
        return pipeFromArray(fns);
    }
    function pipeFromArray(fns) {
        if (fns.length === 0) {
            return identity;
        }
        if (fns.length === 1) {
            return fns[0];
        }
        return function piped(input) {
            return fns.reduce(function (prev, fn) { return fn(prev); }, input);
        };
    }

    var Observable = (function () {
        function Observable(subscribe) {
            if (subscribe) {
                this._subscribe = subscribe;
            }
        }
        Observable.prototype.lift = function (operator) {
            var observable$$1 = new Observable();
            observable$$1.source = this;
            observable$$1.operator = operator;
            return observable$$1;
        };
        Observable.prototype.subscribe = function (observerOrNext, error, complete) {
            var subscriber = isSubscriber(observerOrNext) ? observerOrNext : new SafeSubscriber(observerOrNext, error, complete);
            var _a = this, operator = _a.operator, source = _a.source;
            subscriber.add(operator
                ? operator.call(subscriber, source)
                : source || config.useDeprecatedSynchronousErrorHandling
                    ? this._subscribe(subscriber)
                    : this._trySubscribe(subscriber));
            return subscriber;
        };
        Observable.prototype._trySubscribe = function (sink) {
            try {
                return this._subscribe(sink);
            }
            catch (err) {
                if (config.useDeprecatedSynchronousErrorHandling) {
                    throw err;
                }
                else {
                    canReportError(sink) ? sink.error(err) : reportUnhandledError(err);
                }
            }
        };
        Observable.prototype.forEach = function (next, promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var subscription;
                subscription = _this.subscribe(function (value) {
                    try {
                        next(value);
                    }
                    catch (err) {
                        reject(err);
                        subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
                    }
                }, reject, resolve);
            });
        };
        Observable.prototype._subscribe = function (subscriber) {
            var _a;
            return (_a = this.source) === null || _a === void 0 ? void 0 : _a.subscribe(subscriber);
        };
        Observable.prototype[observable] = function () {
            return this;
        };
        Observable.prototype.pipe = function () {
            var operations = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                operations[_i] = arguments[_i];
            }
            return operations.length ? pipeFromArray(operations)(this) : this;
        };
        Observable.prototype.toPromise = function (promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var value;
                _this.subscribe(function (x) { return (value = x); }, function (err) { return reject(err); }, function () { return resolve(value); });
            });
        };
        Observable.create = function (subscribe) {
            return new Observable(subscribe);
        };
        return Observable;
    }());
    function getPromiseCtor(promiseCtor) {
        var _a;
        return (_a = promiseCtor !== null && promiseCtor !== void 0 ? promiseCtor : config.Promise) !== null && _a !== void 0 ? _a : Promise;
    }
    function canReportError(subscriber) {
        while (subscriber) {
            var _a = subscriber, closed_1 = _a.closed, destination = _a.destination, isStopped = _a.isStopped;
            if (closed_1 || isStopped) {
                return false;
            }
            subscriber = destination && destination instanceof Subscriber ? destination : null;
        }
        return true;
    }
    function isObserver(value) {
        return value && typeof value.next === 'function' && typeof value.error === 'function' && typeof value.complete === 'function';
    }
    function isSubscriber(value) {
        return (value && value instanceof Subscriber) || (isObserver(value) && isSubscription(value));
    }

    function hasLift(source) {
        return typeof (source === null || source === void 0 ? void 0 : source.lift) === 'function';
    }
    function operate(init) {
        return function (source) {
            if (hasLift(source)) {
                return source.lift(function (liftedSource) {
                    try {
                        return init(liftedSource, this);
                    }
                    catch (err) {
                        this.error(err);
                    }
                });
            }
            throw new TypeError('Unable to lift unknown Observable type');
        };
    }

    var OperatorSubscriber = (function (_super) {
        __extends(OperatorSubscriber, _super);
        function OperatorSubscriber(destination, onNext, onError, onComplete, onUnsubscribe) {
            var _this = _super.call(this, destination) || this;
            _this.onUnsubscribe = onUnsubscribe;
            if (onNext) {
                _this._next = function (value) {
                    try {
                        onNext(value);
                    }
                    catch (err) {
                        this.error(err);
                    }
                };
            }
            if (onError) {
                _this._error = function (err) {
                    try {
                        onError(err);
                    }
                    catch (err) {
                        this.destination.error(err);
                    }
                    this.unsubscribe();
                };
            }
            if (onComplete) {
                _this._complete = function () {
                    try {
                        onComplete();
                    }
                    catch (err) {
                        this.destination.error(err);
                    }
                    this.unsubscribe();
                };
            }
            return _this;
        }
        OperatorSubscriber.prototype.unsubscribe = function () {
            var _a;
            !this.closed && ((_a = this.onUnsubscribe) === null || _a === void 0 ? void 0 : _a.call(this));
            _super.prototype.unsubscribe.call(this);
        };
        return OperatorSubscriber;
    }(Subscriber));

    function refCount() {
        return operate(function (source, subscriber) {
            var connection = null;
            source._refCount++;
            var refCounter = new OperatorSubscriber(subscriber, undefined, undefined, undefined, function () {
                if (!source || source._refCount <= 0 || 0 < --source._refCount) {
                    connection = null;
                    return;
                }
                var sharedConnection = source._connection;
                var conn = connection;
                connection = null;
                if (sharedConnection && (!conn || sharedConnection === conn)) {
                    sharedConnection.unsubscribe();
                }
                subscriber.unsubscribe();
            });
            source.subscribe(refCounter);
            if (!refCounter.closed) {
                connection = source.connect();
            }
        });
    }

    var ConnectableObservable = (function (_super) {
        __extends(ConnectableObservable, _super);
        function ConnectableObservable(source, subjectFactory) {
            var _this = _super.call(this) || this;
            _this.source = source;
            _this.subjectFactory = subjectFactory;
            _this._subject = null;
            _this._refCount = 0;
            _this._connection = null;
            return _this;
        }
        ConnectableObservable.prototype._subscribe = function (subscriber) {
            return this.getSubject().subscribe(subscriber);
        };
        ConnectableObservable.prototype.getSubject = function () {
            var subject = this._subject;
            if (!subject || subject.isStopped) {
                this._subject = this.subjectFactory();
            }
            return this._subject;
        };
        ConnectableObservable.prototype._teardown = function () {
            this._refCount = 0;
            var _connection = this._connection;
            this._subject = this._connection = null;
            _connection === null || _connection === void 0 ? void 0 : _connection.unsubscribe();
        };
        ConnectableObservable.prototype.connect = function () {
            var _this = this;
            var connection = this._connection;
            if (!connection) {
                connection = this._connection = new Subscription();
                var subject_1 = this.getSubject();
                connection.add(this.source.subscribe(new OperatorSubscriber(subject_1, undefined, function (err) {
                    _this._teardown();
                    subject_1.error(err);
                }, function () {
                    _this._teardown();
                    subject_1.complete();
                }, function () { return _this._teardown(); })));
                if (connection.closed) {
                    this._connection = null;
                    connection = Subscription.EMPTY;
                }
            }
            return connection;
        };
        ConnectableObservable.prototype.refCount = function () {
            return refCount()(this);
        };
        return ConnectableObservable;
    }(Observable));

    var performanceTimestampProvider = {
        now: function () {
            return (performanceTimestampProvider.delegate || performance).now();
        },
        delegate: undefined,
    };

    var animationFrameProvider = {
        schedule: function (callback) {
            var request = requestAnimationFrame;
            var cancel = cancelAnimationFrame;
            var delegate = animationFrameProvider.delegate;
            if (delegate) {
                request = delegate.requestAnimationFrame;
                cancel = delegate.cancelAnimationFrame;
            }
            var handle = request(function (timestamp) {
                cancel = undefined;
                callback(timestamp);
            });
            return new Subscription(function () { return cancel === null || cancel === void 0 ? void 0 : cancel(handle); });
        },
        requestAnimationFrame: function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var delegate = animationFrameProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.requestAnimationFrame) || requestAnimationFrame).apply(void 0, args);
        },
        cancelAnimationFrame: function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var delegate = animationFrameProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.cancelAnimationFrame) || cancelAnimationFrame).apply(void 0, args);
        },
        delegate: undefined,
    };

    function animationFrames(timestampProvider) {
        return timestampProvider ? animationFramesFactory(timestampProvider) : DEFAULT_ANIMATION_FRAMES;
    }
    function animationFramesFactory(timestampProvider) {
        var schedule = animationFrameProvider.schedule;
        return new Observable(function (subscriber) {
            var subscription = new Subscription();
            var provider = timestampProvider || performanceTimestampProvider;
            var start = provider.now();
            var run = function (timestamp) {
                var now = provider.now();
                subscriber.next({
                    timestamp: timestampProvider ? now : timestamp,
                    elapsed: now - start
                });
                if (!subscriber.closed) {
                    subscription.add(schedule(run));
                }
            };
            subscription.add(schedule(run));
            return subscription;
        });
    }
    var DEFAULT_ANIMATION_FRAMES = animationFramesFactory();

    var ObjectUnsubscribedError = createErrorClass(function (_super) {
        return function ObjectUnsubscribedError() {
            _super(this);
            this.message = 'object unsubscribed';
        };
    });

    var Subject = (function (_super) {
        __extends(Subject, _super);
        function Subject() {
            var _this = _super.call(this) || this;
            _this.observers = [];
            _this.closed = false;
            _this.isStopped = false;
            _this.hasError = false;
            _this.thrownError = null;
            return _this;
        }
        Subject.prototype.lift = function (operator) {
            var subject = new AnonymousSubject(this, this);
            subject.operator = operator;
            return subject;
        };
        Subject.prototype._throwIfClosed = function () {
            if (this.closed) {
                throw new ObjectUnsubscribedError();
            }
        };
        Subject.prototype.next = function (value) {
            this._throwIfClosed();
            if (!this.isStopped) {
                var copy = this.observers.slice();
                for (var _i = 0, copy_1 = copy; _i < copy_1.length; _i++) {
                    var observer = copy_1[_i];
                    observer.next(value);
                }
            }
        };
        Subject.prototype.error = function (err) {
            this._throwIfClosed();
            if (!this.isStopped) {
                this.hasError = this.isStopped = true;
                this.thrownError = err;
                var observers = this.observers;
                while (observers.length) {
                    observers.shift().error(err);
                }
            }
        };
        Subject.prototype.complete = function () {
            this._throwIfClosed();
            if (!this.isStopped) {
                this.isStopped = true;
                var observers = this.observers;
                while (observers.length) {
                    observers.shift().complete();
                }
            }
        };
        Subject.prototype.unsubscribe = function () {
            this.isStopped = this.closed = true;
            this.observers = null;
        };
        Subject.prototype._trySubscribe = function (subscriber) {
            this._throwIfClosed();
            return _super.prototype._trySubscribe.call(this, subscriber);
        };
        Subject.prototype._subscribe = function (subscriber) {
            this._throwIfClosed();
            this._checkFinalizedStatuses(subscriber);
            return this._innerSubscribe(subscriber);
        };
        Subject.prototype._innerSubscribe = function (subscriber) {
            var _this = this;
            var _a = this, hasError = _a.hasError, isStopped = _a.isStopped, observers = _a.observers;
            return hasError || isStopped
                ? EMPTY_SUBSCRIPTION
                : (observers.push(subscriber), new Subscription(function () { return arrRemove(_this.observers, subscriber); }));
        };
        Subject.prototype._checkFinalizedStatuses = function (subscriber) {
            var _a = this, hasError = _a.hasError, thrownError = _a.thrownError, isStopped = _a.isStopped;
            if (hasError) {
                subscriber.error(thrownError);
            }
            else if (isStopped) {
                subscriber.complete();
            }
        };
        Subject.prototype.asObservable = function () {
            var observable = new Observable();
            observable.source = this;
            return observable;
        };
        Subject.create = function (destination, source) {
            return new AnonymousSubject(destination, source);
        };
        return Subject;
    }(Observable));
    var AnonymousSubject = (function (_super) {
        __extends(AnonymousSubject, _super);
        function AnonymousSubject(destination, source) {
            var _this = _super.call(this) || this;
            _this.destination = destination;
            _this.source = source;
            return _this;
        }
        AnonymousSubject.prototype.next = function (value) {
            var _a, _b;
            (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.next) === null || _b === void 0 ? void 0 : _b.call(_a, value);
        };
        AnonymousSubject.prototype.error = function (err) {
            var _a, _b;
            (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.error) === null || _b === void 0 ? void 0 : _b.call(_a, err);
        };
        AnonymousSubject.prototype.complete = function () {
            var _a, _b;
            (_b = (_a = this.destination) === null || _a === void 0 ? void 0 : _a.complete) === null || _b === void 0 ? void 0 : _b.call(_a);
        };
        AnonymousSubject.prototype._subscribe = function (subscriber) {
            var _a, _b;
            return (_b = (_a = this.source) === null || _a === void 0 ? void 0 : _a.subscribe(subscriber)) !== null && _b !== void 0 ? _b : EMPTY_SUBSCRIPTION;
        };
        return AnonymousSubject;
    }(Subject));

    var BehaviorSubject = (function (_super) {
        __extends(BehaviorSubject, _super);
        function BehaviorSubject(_value) {
            var _this = _super.call(this) || this;
            _this._value = _value;
            return _this;
        }
        Object.defineProperty(BehaviorSubject.prototype, "value", {
            get: function () {
                return this.getValue();
            },
            enumerable: false,
            configurable: true
        });
        BehaviorSubject.prototype._subscribe = function (subscriber) {
            var subscription = _super.prototype._subscribe.call(this, subscriber);
            !subscription.closed && subscriber.next(this._value);
            return subscription;
        };
        BehaviorSubject.prototype.getValue = function () {
            var _a = this, hasError = _a.hasError, thrownError = _a.thrownError, _value = _a._value;
            if (hasError) {
                throw thrownError;
            }
            this._throwIfClosed();
            return _value;
        };
        BehaviorSubject.prototype.next = function (value) {
            _super.prototype.next.call(this, (this._value = value));
        };
        return BehaviorSubject;
    }(Subject));

    var dateTimestampProvider = {
        now: function () {
            return (dateTimestampProvider.delegate || Date).now();
        },
        delegate: undefined,
    };

    var ReplaySubject = (function (_super) {
        __extends(ReplaySubject, _super);
        function ReplaySubject(bufferSize, windowTime, timestampProvider) {
            if (bufferSize === void 0) { bufferSize = Infinity; }
            if (windowTime === void 0) { windowTime = Infinity; }
            if (timestampProvider === void 0) { timestampProvider = dateTimestampProvider; }
            var _this = _super.call(this) || this;
            _this.bufferSize = bufferSize;
            _this.windowTime = windowTime;
            _this.timestampProvider = timestampProvider;
            _this.buffer = [];
            _this.infiniteTimeWindow = true;
            _this.infiniteTimeWindow = windowTime === Infinity;
            _this.bufferSize = Math.max(1, bufferSize);
            _this.windowTime = Math.max(1, windowTime);
            return _this;
        }
        ReplaySubject.prototype.next = function (value) {
            var _a = this, isStopped = _a.isStopped, buffer = _a.buffer, infiniteTimeWindow = _a.infiniteTimeWindow, timestampProvider = _a.timestampProvider, windowTime = _a.windowTime;
            if (!isStopped) {
                buffer.push(value);
                !infiniteTimeWindow && buffer.push(timestampProvider.now() + windowTime);
            }
            this.trimBuffer();
            _super.prototype.next.call(this, value);
        };
        ReplaySubject.prototype._subscribe = function (subscriber) {
            this._throwIfClosed();
            this.trimBuffer();
            var subscription = this._innerSubscribe(subscriber);
            var _a = this, infiniteTimeWindow = _a.infiniteTimeWindow, buffer = _a.buffer;
            var copy = buffer.slice();
            for (var i = 0; i < copy.length && !subscriber.closed; i += infiniteTimeWindow ? 1 : 2) {
                subscriber.next(copy[i]);
            }
            this._checkFinalizedStatuses(subscriber);
            return subscription;
        };
        ReplaySubject.prototype.trimBuffer = function () {
            var _a = this, bufferSize = _a.bufferSize, timestampProvider = _a.timestampProvider, buffer = _a.buffer, infiniteTimeWindow = _a.infiniteTimeWindow;
            var adjustedBufferSize = (infiniteTimeWindow ? 1 : 2) * bufferSize;
            bufferSize < Infinity && adjustedBufferSize < buffer.length && buffer.splice(0, buffer.length - adjustedBufferSize);
            if (!infiniteTimeWindow) {
                var now = timestampProvider.now();
                var last = 0;
                for (var i = 1; i < buffer.length && buffer[i] <= now; i += 2) {
                    last = i;
                }
                last && buffer.splice(0, last + 1);
            }
        };
        return ReplaySubject;
    }(Subject));

    var AsyncSubject = (function (_super) {
        __extends(AsyncSubject, _super);
        function AsyncSubject() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.value = null;
            _this.hasValue = false;
            _this.isComplete = false;
            return _this;
        }
        AsyncSubject.prototype._checkFinalizedStatuses = function (subscriber) {
            var _a = this, hasError = _a.hasError, hasValue = _a.hasValue, value = _a.value, thrownError = _a.thrownError, isStopped = _a.isStopped;
            if (hasError) {
                subscriber.error(thrownError);
            }
            else if (isStopped) {
                hasValue && subscriber.next(value);
                subscriber.complete();
            }
        };
        AsyncSubject.prototype.next = function (value) {
            if (!this.isStopped) {
                this.value = value;
                this.hasValue = true;
            }
        };
        AsyncSubject.prototype.complete = function () {
            var _a = this, hasValue = _a.hasValue, value = _a.value, isComplete = _a.isComplete;
            if (!isComplete) {
                this.isComplete = true;
                hasValue && _super.prototype.next.call(this, value);
                _super.prototype.complete.call(this);
            }
        };
        return AsyncSubject;
    }(Subject));

    var Action = (function (_super) {
        __extends(Action, _super);
        function Action(scheduler, work) {
            return _super.call(this) || this;
        }
        Action.prototype.schedule = function (state, delay) {
            if (delay === void 0) { delay = 0; }
            return this;
        };
        return Action;
    }(Subscription));

    var intervalProvider = {
        setInterval: function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var delegate = intervalProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.setInterval) || setInterval).apply(void 0, args);
        },
        clearInterval: function (handle) {
            var delegate = intervalProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.clearInterval) || clearInterval)(handle);
        },
        delegate: undefined,
    };

    var AsyncAction = (function (_super) {
        __extends(AsyncAction, _super);
        function AsyncAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            _this.pending = false;
            return _this;
        }
        AsyncAction.prototype.schedule = function (state, delay) {
            if (delay === void 0) { delay = 0; }
            if (this.closed) {
                return this;
            }
            this.state = state;
            var id = this.id;
            var scheduler = this.scheduler;
            if (id != null) {
                this.id = this.recycleAsyncId(scheduler, id, delay);
            }
            this.pending = true;
            this.delay = delay;
            this.id = this.id || this.requestAsyncId(scheduler, this.id, delay);
            return this;
        };
        AsyncAction.prototype.requestAsyncId = function (scheduler, _id, delay) {
            if (delay === void 0) { delay = 0; }
            return intervalProvider.setInterval(scheduler.flush.bind(scheduler, this), delay);
        };
        AsyncAction.prototype.recycleAsyncId = function (_scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if (delay != null && this.delay === delay && this.pending === false) {
                return id;
            }
            intervalProvider.clearInterval(id);
            return undefined;
        };
        AsyncAction.prototype.execute = function (state, delay) {
            if (this.closed) {
                return new Error('executing a cancelled action');
            }
            this.pending = false;
            var error = this._execute(state, delay);
            if (error) {
                return error;
            }
            else if (this.pending === false && this.id != null) {
                this.id = this.recycleAsyncId(this.scheduler, this.id, null);
            }
        };
        AsyncAction.prototype._execute = function (state, _delay) {
            var errored = false;
            var errorValue = undefined;
            try {
                this.work(state);
            }
            catch (e) {
                errored = true;
                errorValue = (!!e && e) || new Error(e);
            }
            if (errored) {
                this.unsubscribe();
                return errorValue;
            }
        };
        AsyncAction.prototype.unsubscribe = function () {
            if (!this.closed) {
                var _a = this, id = _a.id, scheduler = _a.scheduler;
                var actions = scheduler.actions;
                this.work = this.state = this.scheduler = null;
                this.pending = false;
                arrRemove(actions, this);
                if (id != null) {
                    this.id = this.recycleAsyncId(scheduler, id, null);
                }
                this.delay = null;
                _super.prototype.unsubscribe.call(this);
            }
        };
        return AsyncAction;
    }(Action));

    var nextHandle = 1;
    var resolved;
    var activeHandles = {};
    function findAndClearHandle(handle) {
        if (handle in activeHandles) {
            delete activeHandles[handle];
            return true;
        }
        return false;
    }
    var Immediate = {
        setImmediate: function (cb) {
            var handle = nextHandle++;
            activeHandles[handle] = true;
            if (!resolved) {
                resolved = Promise.resolve();
            }
            resolved.then(function () { return findAndClearHandle(handle) && cb(); });
            return handle;
        },
        clearImmediate: function (handle) {
            findAndClearHandle(handle);
        },
    };

    var setImmediate = Immediate.setImmediate, clearImmediate = Immediate.clearImmediate;
    var immediateProvider = {
        setImmediate: function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var delegate = immediateProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.setImmediate) || setImmediate).apply(void 0, args);
        },
        clearImmediate: function (handle) {
            var delegate = immediateProvider.delegate;
            return ((delegate === null || delegate === void 0 ? void 0 : delegate.clearImmediate) || clearImmediate)(handle);
        },
        delegate: undefined,
    };

    var AsapAction = (function (_super) {
        __extends(AsapAction, _super);
        function AsapAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            return _this;
        }
        AsapAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if (delay !== null && delay > 0) {
                return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
            }
            scheduler.actions.push(this);
            return scheduler.scheduled || (scheduler.scheduled = immediateProvider.setImmediate(scheduler.flush.bind(scheduler, undefined)));
        };
        AsapAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if ((delay != null && delay > 0) || (delay == null && this.delay > 0)) {
                return _super.prototype.recycleAsyncId.call(this, scheduler, id, delay);
            }
            if (scheduler.actions.length === 0) {
                immediateProvider.clearImmediate(id);
                scheduler.scheduled = undefined;
            }
            return undefined;
        };
        return AsapAction;
    }(AsyncAction));

    var Scheduler = (function () {
        function Scheduler(SchedulerAction, now) {
            if (now === void 0) { now = Scheduler.now; }
            this.SchedulerAction = SchedulerAction;
            this.now = now;
        }
        Scheduler.prototype.schedule = function (work, delay, state) {
            if (delay === void 0) { delay = 0; }
            return new this.SchedulerAction(this, work).schedule(state, delay);
        };
        Scheduler.now = dateTimestampProvider.now;
        return Scheduler;
    }());

    var AsyncScheduler = (function (_super) {
        __extends(AsyncScheduler, _super);
        function AsyncScheduler(SchedulerAction, now) {
            if (now === void 0) { now = Scheduler.now; }
            var _this = _super.call(this, SchedulerAction, now) || this;
            _this.actions = [];
            _this.active = false;
            _this.scheduled = undefined;
            return _this;
        }
        AsyncScheduler.prototype.flush = function (action) {
            var actions = this.actions;
            if (this.active) {
                actions.push(action);
                return;
            }
            var error;
            this.active = true;
            do {
                if (error = action.execute(action.state, action.delay)) {
                    break;
                }
            } while (action = actions.shift());
            this.active = false;
            if (error) {
                while (action = actions.shift()) {
                    action.unsubscribe();
                }
                throw error;
            }
        };
        return AsyncScheduler;
    }(Scheduler));

    var AsapScheduler = (function (_super) {
        __extends(AsapScheduler, _super);
        function AsapScheduler() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AsapScheduler.prototype.flush = function (action) {
            this.active = true;
            this.scheduled = undefined;
            var actions = this.actions;
            var error;
            var index = -1;
            action = action || actions.shift();
            var count = actions.length;
            do {
                if (error = action.execute(action.state, action.delay)) {
                    break;
                }
            } while (++index < count && (action = actions.shift()));
            this.active = false;
            if (error) {
                while (++index < count && (action = actions.shift())) {
                    action.unsubscribe();
                }
                throw error;
            }
        };
        return AsapScheduler;
    }(AsyncScheduler));

    var asapScheduler = new AsapScheduler(AsapAction);
    var asap = asapScheduler;

    var asyncScheduler = new AsyncScheduler(AsyncAction);
    var async = asyncScheduler;

    var QueueAction = (function (_super) {
        __extends(QueueAction, _super);
        function QueueAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            return _this;
        }
        QueueAction.prototype.schedule = function (state, delay) {
            if (delay === void 0) { delay = 0; }
            if (delay > 0) {
                return _super.prototype.schedule.call(this, state, delay);
            }
            this.delay = delay;
            this.state = state;
            this.scheduler.flush(this);
            return this;
        };
        QueueAction.prototype.execute = function (state, delay) {
            return (delay > 0 || this.closed) ?
                _super.prototype.execute.call(this, state, delay) :
                this._execute(state, delay);
        };
        QueueAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if ((delay != null && delay > 0) || (delay == null && this.delay > 0)) {
                return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
            }
            return scheduler.flush(this);
        };
        return QueueAction;
    }(AsyncAction));

    var QueueScheduler = (function (_super) {
        __extends(QueueScheduler, _super);
        function QueueScheduler() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return QueueScheduler;
    }(AsyncScheduler));

    var queueScheduler = new QueueScheduler(QueueAction);
    var queue = queueScheduler;

    var AnimationFrameAction = (function (_super) {
        __extends(AnimationFrameAction, _super);
        function AnimationFrameAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            return _this;
        }
        AnimationFrameAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if (delay !== null && delay > 0) {
                return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
            }
            scheduler.actions.push(this);
            return scheduler.scheduled || (scheduler.scheduled = animationFrameProvider.requestAnimationFrame(function () { return scheduler.flush(undefined); }));
        };
        AnimationFrameAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            if ((delay != null && delay > 0) || (delay == null && this.delay > 0)) {
                return _super.prototype.recycleAsyncId.call(this, scheduler, id, delay);
            }
            if (scheduler.actions.length === 0) {
                animationFrameProvider.cancelAnimationFrame(id);
                scheduler.scheduled = undefined;
            }
            return undefined;
        };
        return AnimationFrameAction;
    }(AsyncAction));

    var AnimationFrameScheduler = (function (_super) {
        __extends(AnimationFrameScheduler, _super);
        function AnimationFrameScheduler() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnimationFrameScheduler.prototype.flush = function (action) {
            this.active = true;
            this.scheduled = undefined;
            var actions = this.actions;
            var error;
            var index = -1;
            action = action || actions.shift();
            var count = actions.length;
            do {
                if (error = action.execute(action.state, action.delay)) {
                    break;
                }
            } while (++index < count && (action = actions.shift()));
            this.active = false;
            if (error) {
                while (++index < count && (action = actions.shift())) {
                    action.unsubscribe();
                }
                throw error;
            }
        };
        return AnimationFrameScheduler;
    }(AsyncScheduler));

    var animationFrameScheduler = new AnimationFrameScheduler(AnimationFrameAction);
    var animationFrame = animationFrameScheduler;

    var VirtualTimeScheduler = (function (_super) {
        __extends(VirtualTimeScheduler, _super);
        function VirtualTimeScheduler(SchedulerAction, maxFrames) {
            if (SchedulerAction === void 0) { SchedulerAction = VirtualAction; }
            if (maxFrames === void 0) { maxFrames = Infinity; }
            var _this = _super.call(this, SchedulerAction, function () { return _this.frame; }) || this;
            _this.maxFrames = maxFrames;
            _this.frame = 0;
            _this.index = -1;
            return _this;
        }
        VirtualTimeScheduler.prototype.flush = function () {
            var _a = this, actions = _a.actions, maxFrames = _a.maxFrames;
            var error, action;
            while ((action = actions[0]) && action.delay <= maxFrames) {
                actions.shift();
                this.frame = action.delay;
                if (error = action.execute(action.state, action.delay)) {
                    break;
                }
            }
            if (error) {
                while (action = actions.shift()) {
                    action.unsubscribe();
                }
                throw error;
            }
        };
        VirtualTimeScheduler.frameTimeFactor = 10;
        return VirtualTimeScheduler;
    }(AsyncScheduler));
    var VirtualAction = (function (_super) {
        __extends(VirtualAction, _super);
        function VirtualAction(scheduler, work, index) {
            if (index === void 0) { index = scheduler.index += 1; }
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            _this.index = index;
            _this.active = true;
            _this.index = scheduler.index = index;
            return _this;
        }
        VirtualAction.prototype.schedule = function (state, delay) {
            if (delay === void 0) { delay = 0; }
            if (Number.isFinite(delay)) {
                if (!this.id) {
                    return _super.prototype.schedule.call(this, state, delay);
                }
                this.active = false;
                var action = new VirtualAction(this.scheduler, this.work);
                this.add(action);
                return action.schedule(state, delay);
            }
            else {
                return Subscription.EMPTY;
            }
        };
        VirtualAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            this.delay = scheduler.frame + delay;
            var actions = scheduler.actions;
            actions.push(this);
            actions.sort(VirtualAction.sortActions);
            return true;
        };
        VirtualAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) { delay = 0; }
            return undefined;
        };
        VirtualAction.prototype._execute = function (state, delay) {
            if (this.active === true) {
                return _super.prototype._execute.call(this, state, delay);
            }
        };
        VirtualAction.sortActions = function (a, b) {
            if (a.delay === b.delay) {
                if (a.index === b.index) {
                    return 0;
                }
                else if (a.index > b.index) {
                    return 1;
                }
                else {
                    return -1;
                }
            }
            else if (a.delay > b.delay) {
                return 1;
            }
            else {
                return -1;
            }
        };
        return VirtualAction;
    }(AsyncAction));

    var EMPTY = new Observable(function (subscriber) { return subscriber.complete(); });
    function empty(scheduler) {
        return scheduler ? emptyScheduled(scheduler) : EMPTY;
    }
    function emptyScheduled(scheduler) {
        return new Observable(function (subscriber) { return scheduler.schedule(function () { return subscriber.complete(); }); });
    }

    function isScheduler(value) {
        return value && typeof value.schedule === 'function';
    }

    var subscribeToArray = function (array) { return function (subscriber) {
        for (var i = 0, len = array.length; i < len && !subscriber.closed; i++) {
            subscriber.next(array[i]);
        }
        subscriber.complete();
    }; };

    function scheduleArray(input, scheduler) {
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            var i = 0;
            sub.add(scheduler.schedule(function () {
                if (i === input.length) {
                    subscriber.complete();
                    return;
                }
                subscriber.next(input[i++]);
                if (!subscriber.closed) {
                    sub.add(this.schedule());
                }
            }));
            return sub;
        });
    }

    function fromArray(input, scheduler) {
        if (!scheduler) {
            return new Observable(subscribeToArray(input));
        }
        else {
            return scheduleArray(input, scheduler);
        }
    }

    function of() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var scheduler = args[args.length - 1];
        if (isScheduler(scheduler)) {
            args.pop();
            return scheduleArray(args, scheduler);
        }
        else {
            return fromArray(args);
        }
    }

    function throwError(errorOrErrorFactory, scheduler) {
        if (!scheduler) {
            return new Observable(function (subscriber) {
                return subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
            });
        }
        else {
            return new Observable(function (subscriber) {
                return scheduler.schedule(function () {
                    subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
                });
            });
        }
    }

    (function (NotificationKind) {
        NotificationKind["NEXT"] = "N";
        NotificationKind["ERROR"] = "E";
        NotificationKind["COMPLETE"] = "C";
    })(exports.NotificationKind || (exports.NotificationKind = {}));
    var Notification = (function () {
        function Notification(kind, value, error) {
            this.kind = kind;
            this.value = value;
            this.error = error;
            this.hasValue = kind === 'N';
        }
        Notification.prototype.observe = function (observer) {
            return observeNotification(this, observer);
        };
        Notification.prototype.do = function (nextHandler, errorHandler, completeHandler) {
            var _a = this, kind = _a.kind, value = _a.value, error = _a.error;
            return kind === 'N' ? nextHandler === null || nextHandler === void 0 ? void 0 : nextHandler(value) : kind === 'E' ? errorHandler === null || errorHandler === void 0 ? void 0 : errorHandler(error) : completeHandler === null || completeHandler === void 0 ? void 0 : completeHandler();
        };
        Notification.prototype.accept = function (nextOrObserver, error, complete) {
            var _a;
            return typeof ((_a = nextOrObserver) === null || _a === void 0 ? void 0 : _a.next) === 'function'
                ? this.observe(nextOrObserver)
                : this.do(nextOrObserver, error, complete);
        };
        Notification.prototype.toObservable = function () {
            var _a = this, kind = _a.kind, value = _a.value, error = _a.error;
            var result = kind === 'N'
                ?
                    of(value)
                :
                    kind === 'E'
                        ?
                            throwError(error)
                        :
                            kind === 'C'
                                ?
                                    EMPTY
                                :
                                    0;
            if (!result) {
                throw new TypeError("Unexpected notification kind " + kind);
            }
            return result;
        };
        Notification.createNext = function (value) {
            return new Notification('N', value);
        };
        Notification.createError = function (err) {
            return new Notification('E', undefined, err);
        };
        Notification.createComplete = function () {
            return Notification.completeNotification;
        };
        Notification.completeNotification = new Notification('C');
        return Notification;
    }());
    function observeNotification(notification, observer) {
        var _a, _b, _c;
        var _d = notification, kind = _d.kind, value = _d.value, error = _d.error;
        if (typeof kind !== 'string') {
            throw new TypeError('Invalid notification, missing "kind"');
        }
        kind === 'N' ? (_a = observer.next) === null || _a === void 0 ? void 0 : _a.call(observer, value) : kind === 'E' ? (_b = observer.error) === null || _b === void 0 ? void 0 : _b.call(observer, error) : (_c = observer.complete) === null || _c === void 0 ? void 0 : _c.call(observer);
    }
    var COMPLETE_NOTIFICATION = (function () { return createNotification('C', undefined, undefined); })();
    function errorNotification(error) {
        return createNotification('E', undefined, error);
    }
    function nextNotification(value) {
        return createNotification('N', value, undefined);
    }
    function createNotification(kind, value, error) {
        return {
            kind: kind,
            value: value,
            error: error,
        };
    }

    function isObservable(obj) {
        return !!obj && (obj instanceof Observable || (typeof obj.lift === 'function' && typeof obj.subscribe === 'function'));
    }

    var EmptyError = createErrorClass(function (_super) { return function EmptyError() {
        _super(this);
        this.message = 'no elements in sequence';
    }; });

    function lastValueFrom(source) {
        return new Promise(function (resolve, reject) {
            var _hasValue = false;
            var _value;
            source.subscribe({
                next: function (value) {
                    _value = value;
                    _hasValue = true;
                },
                error: reject,
                complete: function () {
                    if (_hasValue) {
                        resolve(_value);
                    }
                    else {
                        reject(new EmptyError());
                    }
                },
            });
        });
    }

    function firstValueFrom(source) {
        return new Promise(function (resolve, reject) {
            var subs = new Subscription();
            subs.add(source.subscribe({
                next: function (value) {
                    resolve(value);
                    subs.unsubscribe();
                },
                error: reject,
                complete: function () {
                    reject(new EmptyError());
                },
            }));
        });
    }

    var ArgumentOutOfRangeError = createErrorClass(function (_super) {
        return function ArgumentOutOfRangeError() {
            _super(this);
            this.message = 'argument out of range';
        };
    });

    var NotFoundError = createErrorClass(function (_super) {
        return function NotFoundError(message) {
            _super(this);
            this.message = message;
        };
    });

    var SequenceError = createErrorClass(function (_super) {
        return function SequenceError(message) {
            _super(this);
            this.message = message;
        };
    });

    function isValidDate(value) {
        return value instanceof Date && !isNaN(value);
    }

    var subscribeToPromise = function (promise) { return function (subscriber) {
        promise.then(function (value) {
            if (!subscriber.closed) {
                subscriber.next(value);
                subscriber.complete();
            }
        }, function (err) { return subscriber.error(err); })
            .then(null, reportUnhandledError);
        return subscriber;
    }; };

    function getSymbolIterator() {
        if (typeof Symbol !== 'function' || !Symbol.iterator) {
            return '@@iterator';
        }
        return Symbol.iterator;
    }
    var iterator = getSymbolIterator();

    var subscribeToIterable = function (iterable) { return function (subscriber) {
        var iterator$$1 = iterable[iterator]();
        do {
            var item = void 0;
            try {
                item = iterator$$1.next();
            }
            catch (err) {
                subscriber.error(err);
                return;
            }
            if (item.done) {
                subscriber.complete();
                break;
            }
            subscriber.next(item.value);
            if (subscriber.closed) {
                break;
            }
        } while (true);
        if (typeof iterator$$1.return === 'function') {
            subscriber.add(function () {
                if (iterator$$1.return) {
                    iterator$$1.return();
                }
            });
        }
        return subscriber;
    }; };

    var subscribeToObservable = function (obj) { return function (subscriber) {
        var obs = obj[observable]();
        if (typeof obs.subscribe !== 'function') {
            throw new TypeError('Provided object does not correctly implement Symbol.observable');
        }
        else {
            return obs.subscribe(subscriber);
        }
    }; };

    var isArrayLike = (function (x) { return x && typeof x.length === 'number' && typeof x !== 'function'; });

    function isPromise(value) {
        return !!value && typeof value.subscribe !== 'function' && typeof value.then === 'function';
    }

    function isObject(x) {
        return x !== null && typeof x === 'object';
    }

    function subscribeToAsyncIterable(asyncIterable) {
        return function (subscriber) {
            process(asyncIterable, subscriber).catch(function (err) { return subscriber.error(err); });
        };
    }
    function process(asyncIterable, subscriber) {
        var asyncIterable_1, asyncIterable_1_1;
        var e_1, _a;
        return __awaiter(this, void 0, void 0, function () {
            var value, e_1_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 5, 6, 11]);
                        asyncIterable_1 = __asyncValues(asyncIterable);
                        _b.label = 1;
                    case 1: return [4, asyncIterable_1.next()];
                    case 2:
                        if (!(asyncIterable_1_1 = _b.sent(), !asyncIterable_1_1.done)) return [3, 4];
                        value = asyncIterable_1_1.value;
                        subscriber.next(value);
                        _b.label = 3;
                    case 3: return [3, 1];
                    case 4: return [3, 11];
                    case 5:
                        e_1_1 = _b.sent();
                        e_1 = { error: e_1_1 };
                        return [3, 11];
                    case 6:
                        _b.trys.push([6, , 9, 10]);
                        if (!(asyncIterable_1_1 && !asyncIterable_1_1.done && (_a = asyncIterable_1.return))) return [3, 8];
                        return [4, _a.call(asyncIterable_1)];
                    case 7:
                        _b.sent();
                        _b.label = 8;
                    case 8: return [3, 10];
                    case 9:
                        if (e_1) throw e_1.error;
                        return [7];
                    case 10: return [7];
                    case 11:
                        subscriber.complete();
                        return [2];
                }
            });
        });
    }

    function scheduleObservable(input, scheduler) {
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            sub.add(scheduler.schedule(function () {
                var observable$$1 = input[observable]();
                sub.add(observable$$1.subscribe({
                    next: function (value) { sub.add(scheduler.schedule(function () { return subscriber.next(value); })); },
                    error: function (err) { sub.add(scheduler.schedule(function () { return subscriber.error(err); })); },
                    complete: function () { sub.add(scheduler.schedule(function () { return subscriber.complete(); })); },
                }));
            }));
            return sub;
        });
    }

    function schedulePromise(input, scheduler) {
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            sub.add(scheduler.schedule(function () { return input.then(function (value) {
                sub.add(scheduler.schedule(function () {
                    subscriber.next(value);
                    sub.add(scheduler.schedule(function () { return subscriber.complete(); }));
                }));
            }, function (err) {
                sub.add(scheduler.schedule(function () { return subscriber.error(err); }));
            }); }));
            return sub;
        });
    }

    function scheduleIterable(input, scheduler) {
        if (!input) {
            throw new Error('Iterable cannot be null');
        }
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            var iterator$$1;
            sub.add(function () {
                if (iterator$$1 && typeof iterator$$1.return === 'function') {
                    iterator$$1.return();
                }
            });
            sub.add(scheduler.schedule(function () {
                iterator$$1 = input[iterator]();
                sub.add(scheduler.schedule(function () {
                    if (subscriber.closed) {
                        return;
                    }
                    var value;
                    var done;
                    try {
                        var result = iterator$$1.next();
                        value = result.value;
                        done = result.done;
                    }
                    catch (err) {
                        subscriber.error(err);
                        return;
                    }
                    if (done) {
                        subscriber.complete();
                    }
                    else {
                        subscriber.next(value);
                        this.schedule();
                    }
                }));
            }));
            return sub;
        });
    }

    function isInteropObservable(input) {
        return input && typeof input[observable] === 'function';
    }

    function isIterable(input) {
        return input && typeof input[iterator] === 'function';
    }

    function scheduleAsyncIterable(input, scheduler) {
        if (!input) {
            throw new Error('Iterable cannot be null');
        }
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            sub.add(scheduler.schedule(function () {
                var iterator = input[Symbol.asyncIterator]();
                sub.add(scheduler.schedule(function () {
                    var _this = this;
                    iterator.next().then(function (result) {
                        if (result.done) {
                            subscriber.complete();
                        }
                        else {
                            subscriber.next(result.value);
                            _this.schedule();
                        }
                    });
                }));
            }));
            return sub;
        });
    }

    function scheduled(input, scheduler) {
        if (input != null) {
            if (isInteropObservable(input)) {
                return scheduleObservable(input, scheduler);
            }
            else if (isPromise(input)) {
                return schedulePromise(input, scheduler);
            }
            else if (isArrayLike(input)) {
                return scheduleArray(input, scheduler);
            }
            else if (isIterable(input) || typeof input === 'string') {
                return scheduleIterable(input, scheduler);
            }
            else if (Symbol && Symbol.asyncIterator && typeof input[Symbol.asyncIterator] === 'function') {
                return scheduleAsyncIterable(input, scheduler);
            }
        }
        throw new TypeError((input !== null && typeof input || input) + ' is not observable');
    }

    function from(input, scheduler) {
        if (!scheduler) {
            if (input instanceof Observable) {
                return input;
            }
            return new Observable(subscribeTo(input));
        }
        else {
            return scheduled(input, scheduler);
        }
    }
    function subscribeTo(result) {
        if (result && typeof result[observable] === 'function') {
            return subscribeToObservable(result);
        }
        else if (isArrayLike(result)) {
            return subscribeToArray(result);
        }
        else if (isPromise(result)) {
            return subscribeToPromise(result);
        }
        else if (result && typeof result[iterator] === 'function') {
            return subscribeToIterable(result);
        }
        else if (Symbol && Symbol.asyncIterator &&
            !!result && typeof result[Symbol.asyncIterator] === 'function') {
            return subscribeToAsyncIterable(result);
        }
        else {
            var value = isObject(result) ? 'an invalid object' : "'" + result + "'";
            var msg = "You provided " + value + " where a stream was expected."
                + ' You can provide an Observable, Promise, Array, AsyncIterable, or Iterable.';
            throw new TypeError(msg);
        }
    }

    var TimeoutError = createErrorClass(function (_super) {
        return function TimeoutError(info) {
            if (info === void 0) { info = null; }
            _super(this);
            this.message = 'Timeout has occurred';
            this.name = 'TimeoutError';
            this.info = info;
        };
    });
    function timeout(config, schedulerArg) {
        var _a = (isValidDate(config)
            ? { first: config }
            : typeof config === 'number'
                ? { each: config }
                : config), first = _a.first, each = _a.each, _b = _a.with, _with = _b === void 0 ? timeoutErrorFactory : _b, _c = _a.scheduler, scheduler = _c === void 0 ? schedulerArg !== null && schedulerArg !== void 0 ? schedulerArg : asyncScheduler : _c, _d = _a.meta, meta = _d === void 0 ? null : _d;
        if (first == null && each == null) {
            throw new TypeError('No timeout provided.');
        }
        return operate(function (source, subscriber) {
            var originalSourceSubscription;
            var timerSubscription;
            var lastValue = null;
            var seen = 0;
            var startTimer = function (delay) {
                subscriber.add((timerSubscription = scheduler.schedule(function () {
                    var withObservable;
                    try {
                        withObservable = from(_with({
                            meta: meta,
                            lastValue: lastValue,
                            seen: seen,
                        }));
                    }
                    catch (err) {
                        subscriber.error(err);
                        return;
                    }
                    originalSourceSubscription.unsubscribe();
                    withObservable.subscribe(subscriber);
                }, delay)));
            };
            subscriber.add((originalSourceSubscription = source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                timerSubscription.unsubscribe();
                seen++;
                subscriber.next((lastValue = value));
                each > 0 && startTimer(each);
            }, undefined, undefined, function () {
                lastValue = null;
            }))));
            startTimer(first != null ? (typeof first === 'number' ? first : +first - scheduler.now()) : each);
        });
    }
    function timeoutErrorFactory(info) {
        throw new TimeoutError(info);
    }

    function map(project, thisArg) {
        return operate(function (source, subscriber) {
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                subscriber.next(project.call(thisArg, value, index++));
            }));
        });
    }

    var isArray = Array.isArray;
    function callOrApply(fn, args) {
        return isArray(args) ? fn.apply(void 0, args) : fn(args);
    }
    function mapOneOrManyArgs(fn) {
        return map(function (args) { return callOrApply(fn, args); });
    }

    function bindCallback(callbackFunc, resultSelector, scheduler) {
        if (resultSelector) {
            if (isScheduler(resultSelector)) {
                scheduler = resultSelector;
            }
            else {
                return function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    return bindCallback(callbackFunc, scheduler).apply(void 0, args).pipe(mapOneOrManyArgs(resultSelector));
                };
            }
        }
        return function () {
            var _this = this;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var results;
            var hasResults = false;
            var hasError = false;
            var error;
            return new Observable(function (subscriber) {
                if (!scheduler) {
                    var isCurrentlyAsync_1 = false;
                    var hasCompletedSynchronously_1 = false;
                    if (hasResults) {
                        subscriber.next(results);
                        subscriber.complete();
                    }
                    else if (hasError) {
                        subscriber.error(error);
                    }
                    else {
                        var handler = function () {
                            var innerArgs = [];
                            for (var _i = 0; _i < arguments.length; _i++) {
                                innerArgs[_i] = arguments[_i];
                            }
                            hasResults = true;
                            results = innerArgs.length <= 1 ? innerArgs[0] : innerArgs;
                            subscriber.next(results);
                            if (isCurrentlyAsync_1) {
                                subscriber.complete();
                            }
                            else {
                                hasCompletedSynchronously_1 = true;
                            }
                        };
                        try {
                            callbackFunc.apply(_this, __spreadArrays(args, [handler]));
                        }
                        catch (err) {
                            hasError = true;
                            error = err;
                            subscriber.error(err);
                        }
                        isCurrentlyAsync_1 = true;
                        if (hasCompletedSynchronously_1 && !hasError) {
                            subscriber.complete();
                        }
                    }
                    return;
                }
                else {
                    var scheduleNext_1 = function (value) {
                        hasResults = true;
                        results = value.length <= 1 ? value[0] : value;
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.next(results);
                            subscriber.add(scheduler.schedule(function () {
                                subscriber.complete();
                            }));
                        }));
                    };
                    var scheduleError_1 = function (err) {
                        hasError = true;
                        error = err;
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.error(error);
                        }));
                    };
                    return scheduler.schedule(function () {
                        if (hasResults) {
                            scheduleNext_1(results);
                        }
                        else if (hasError) {
                            scheduleError_1(error);
                        }
                        else {
                            try {
                                callbackFunc.apply(_this, __spreadArrays(args, [
                                    function () {
                                        var innerArgs = [];
                                        for (var _i = 0; _i < arguments.length; _i++) {
                                            innerArgs[_i] = arguments[_i];
                                        }
                                        return scheduleNext_1(innerArgs);
                                    }
                                ]));
                            }
                            catch (err) {
                                scheduleError_1(err);
                                return;
                            }
                        }
                    });
                }
            });
        };
    }

    function bindNodeCallback(callbackFunc, resultSelector, scheduler) {
        if (resultSelector) {
            if (isScheduler(resultSelector)) {
                scheduler = resultSelector;
            }
            else {
                return function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    return bindNodeCallback(callbackFunc, scheduler).apply(void 0, args).pipe(mapOneOrManyArgs(resultSelector));
                };
            }
        }
        return function () {
            var _this = this;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var results;
            var hasResults = false;
            var hasError = false;
            var error;
            return new Observable(function (subscriber) {
                if (!scheduler) {
                    var isCurrentlyAsync_1 = false;
                    var hasCompletedSynchronously_1 = false;
                    if (hasResults) {
                        subscriber.next(results);
                        subscriber.complete();
                    }
                    else if (hasError) {
                        subscriber.error(error);
                    }
                    else {
                        var handler = function () {
                            var innerArgs = [];
                            for (var _i = 0; _i < arguments.length; _i++) {
                                innerArgs[_i] = arguments[_i];
                            }
                            var err = innerArgs.shift();
                            if (err != null) {
                                hasError = true;
                                error = err;
                                subscriber.error(err);
                            }
                            else {
                                hasResults = true;
                                results = innerArgs.length <= 1 ? innerArgs[0] : innerArgs;
                                subscriber.next(results);
                                if (isCurrentlyAsync_1) {
                                    subscriber.complete();
                                }
                                else {
                                    hasCompletedSynchronously_1 = true;
                                }
                            }
                        };
                        try {
                            callbackFunc.apply(_this, __spreadArrays(args, [handler]));
                        }
                        catch (err) {
                            hasError = true;
                            error = err;
                            subscriber.error(err);
                        }
                        isCurrentlyAsync_1 = true;
                        if (hasCompletedSynchronously_1 && !hasError) {
                            subscriber.complete();
                        }
                    }
                    return;
                }
                else {
                    var scheduleNext_1 = function (value) {
                        hasResults = true;
                        results = value.length <= 1 ? value[0] : value;
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.next(results);
                            subscriber.add(scheduler.schedule(function () {
                                subscriber.complete();
                            }));
                        }));
                    };
                    var scheduleError_1 = function (err) {
                        hasError = true;
                        error = err;
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.error(error);
                        }));
                    };
                    return scheduler.schedule(function () {
                        if (hasResults) {
                            scheduleNext_1(results);
                        }
                        else if (hasError) {
                            scheduleError_1(error);
                        }
                        else {
                            try {
                                callbackFunc.apply(_this, __spreadArrays(args, [
                                    function () {
                                        var innerArgs = [];
                                        for (var _i = 0; _i < arguments.length; _i++) {
                                            innerArgs[_i] = arguments[_i];
                                        }
                                        var err = innerArgs.shift();
                                        if (err != null) {
                                            scheduleError_1(err);
                                        }
                                        else {
                                            scheduleNext_1(innerArgs);
                                        }
                                    },
                                ]));
                            }
                            catch (err) {
                                scheduleError_1(err);
                                return;
                            }
                        }
                    });
                }
            });
        };
    }

    var isArray$1 = Array.isArray;
    var getPrototypeOf = Object.getPrototypeOf, objectProto = Object.prototype, getKeys = Object.keys;
    function argsArgArrayOrObject(args) {
        if (args.length === 1) {
            var first_1 = args[0];
            if (isArray$1(first_1)) {
                return { args: first_1, keys: null };
            }
            if (isPOJO(first_1)) {
                var keys = getKeys(first_1);
                return {
                    args: keys.map(function (key) { return first_1[key]; }),
                    keys: keys,
                };
            }
        }
        return { args: args, keys: null };
    }
    function isPOJO(obj) {
        return obj && typeof obj === 'object' && getPrototypeOf(obj) === objectProto;
    }

    function combineLatest() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var resultSelector = undefined;
        var scheduler = undefined;
        if (isScheduler(args[args.length - 1])) {
            scheduler = args.pop();
        }
        if (typeof args[args.length - 1] === 'function') {
            resultSelector = args.pop();
        }
        var _a = argsArgArrayOrObject(args), observables = _a.args, keys = _a.keys;
        var result = new Observable(combineLatestInit(observables, scheduler, keys
            ?
                function (args) {
                    var value = {};
                    for (var i = 0; i < args.length; i++) {
                        value[keys[i]] = args[i];
                    }
                    return value;
                }
            :
                identity));
        if (resultSelector) {
            return result.pipe(mapOneOrManyArgs(resultSelector));
        }
        return result;
    }
    var CombineLatestSubscriber = (function (_super) {
        __extends(CombineLatestSubscriber, _super);
        function CombineLatestSubscriber(destination, _next, shouldComplete) {
            var _this = _super.call(this, destination) || this;
            _this._next = _next;
            _this.shouldComplete = shouldComplete;
            return _this;
        }
        CombineLatestSubscriber.prototype._complete = function () {
            if (this.shouldComplete()) {
                _super.prototype._complete.call(this);
            }
            else {
                this.unsubscribe();
            }
        };
        return CombineLatestSubscriber;
    }(Subscriber));
    function combineLatestInit(observables, scheduler, valueTransform) {
        if (scheduler === void 0) { scheduler = undefined; }
        if (valueTransform === void 0) { valueTransform = identity; }
        return function (subscriber) {
            var primarySubscribe = function () {
                var length = observables.length;
                var values = new Array(length);
                var active = length;
                var hasValues = observables.map(function () { return false; });
                var waitingForFirstValues = true;
                var emit = function () { return subscriber.next(valueTransform(values.slice())); };
                var _loop_1 = function (i) {
                    var subscribe = function () {
                        var source = from(observables[i], scheduler);
                        source.subscribe(new CombineLatestSubscriber(subscriber, function (value) {
                            values[i] = value;
                            if (waitingForFirstValues) {
                                hasValues[i] = true;
                                waitingForFirstValues = !hasValues.every(identity);
                            }
                            if (!waitingForFirstValues) {
                                emit();
                            }
                        }, function () { return --active === 0; }));
                    };
                    maybeSchedule(scheduler, subscribe, subscriber);
                };
                for (var i = 0; i < length; i++) {
                    _loop_1(i);
                }
            };
            maybeSchedule(scheduler, primarySubscribe, subscriber);
        };
    }
    function maybeSchedule(scheduler, execute, subscription) {
        if (scheduler) {
            subscription.add(scheduler.schedule(execute));
        }
        else {
            execute();
        }
    }

    function mergeMap(project, resultSelector, concurrent) {
        if (concurrent === void 0) { concurrent = Infinity; }
        if (typeof resultSelector === 'function') {
            return function (source) {
                return source.pipe(mergeMap(function (a, i) { return from(project(a, i)).pipe(map(function (b, ii) { return resultSelector(a, b, i, ii); })); }, concurrent));
            };
        }
        else if (typeof resultSelector === 'number') {
            concurrent = resultSelector;
        }
        return operate(function (source, subscriber) {
            var isComplete = false;
            var active = 0;
            var index = 0;
            var buffer = [];
            var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
            var tryInnerSub = function () {
                while (active < concurrent && buffer.length > 0) {
                    doInnerSub(buffer.shift());
                }
            };
            var doInnerSub = function (value) {
                active++;
                subscriber.add(from(project(value, index++)).subscribe(new OperatorSubscriber(subscriber, function (innerValue) { return subscriber.next(innerValue); }, undefined, function () {
                    active--;
                    buffer.length && tryInnerSub();
                    checkComplete();
                })));
            };
            var outerSubs;
            outerSubs = source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
                isComplete = true;
                checkComplete();
                outerSubs === null || outerSubs === void 0 ? void 0 : outerSubs.unsubscribe();
            }));
            return function () {
                buffer = null;
            };
        });
    }
    var flatMap = mergeMap;

    function mergeAll(concurrent) {
        if (concurrent === void 0) { concurrent = Infinity; }
        return mergeMap(identity, concurrent);
    }

    function concatAll() {
        return mergeAll(1);
    }

    function concat() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var scheduler;
        if (isScheduler(args[args.length - 1])) {
            scheduler = args.pop();
        }
        return concatAll()(fromArray(args, scheduler));
    }

    function defer(observableFactory) {
        return new Observable(function (subscriber) {
            var input;
            try {
                input = observableFactory();
            }
            catch (err) {
                subscriber.error(err);
                return undefined;
            }
            var source = from(input);
            return source.subscribe(subscriber);
        });
    }

    function forkJoin() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var resultSelector;
        if (typeof args[args.length - 1] === 'function') {
            resultSelector = args.pop();
        }
        var _a = argsArgArrayOrObject(args), sources = _a.args, keys = _a.keys;
        if (resultSelector) {
            return forkJoinInternal(sources, keys).pipe(map(function (values) { return resultSelector.apply(void 0, values); }));
        }
        return forkJoinInternal(sources, keys);
    }
    function forkJoinInternal(sources, keys) {
        return new Observable(function (subscriber) {
            var len = sources.length;
            if (len === 0) {
                subscriber.complete();
                return;
            }
            var values = new Array(len);
            var completed = 0;
            var emitted = 0;
            var _loop_1 = function (i) {
                var source = from(sources[i]);
                var hasValue = false;
                subscriber.add(source.subscribe({
                    next: function (value) {
                        if (!hasValue) {
                            hasValue = true;
                            emitted++;
                        }
                        values[i] = value;
                    },
                    error: function (err) { return subscriber.error(err); },
                    complete: function () {
                        completed++;
                        if (completed === len || !hasValue) {
                            if (emitted === len) {
                                subscriber.next(keys ?
                                    keys.reduce(function (result, key, i) { return (result[key] = values[i], result); }, {}) :
                                    values);
                            }
                            subscriber.complete();
                        }
                    }
                }));
            };
            for (var i = 0; i < len; i++) {
                _loop_1(i);
            }
        });
    }

    function fromEvent(target, eventName, options, resultSelector) {
        if (isFunction(options)) {
            resultSelector = options;
            options = undefined;
        }
        if (resultSelector) {
            return fromEvent(target, eventName, options).pipe(mapOneOrManyArgs(resultSelector));
        }
        return new Observable(function (subscriber) {
            var handler = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return subscriber.next(args.length > 1 ? args : args[0]);
            };
            if (isEventTarget(target)) {
                target.addEventListener(eventName, handler, options);
                return function () { return target.removeEventListener(eventName, handler, options); };
            }
            if (isJQueryStyleEventEmitter(target)) {
                target.on(eventName, handler);
                return function () { return target.off(eventName, handler); };
            }
            if (isNodeStyleEventEmitter(target)) {
                target.addListener(eventName, handler);
                return function () { return target.removeListener(eventName, handler); };
            }
            if (isArrayLike(target)) {
                return mergeMap(function (target) { return fromEvent(target, eventName, options); })(fromArray(target)).subscribe(subscriber);
            }
            subscriber.error(new TypeError('Invalid event target'));
            return;
        });
    }
    function isNodeStyleEventEmitter(sourceObj) {
        return sourceObj && typeof sourceObj.addListener === 'function' && typeof sourceObj.removeListener === 'function';
    }
    function isJQueryStyleEventEmitter(sourceObj) {
        return sourceObj && typeof sourceObj.on === 'function' && typeof sourceObj.off === 'function';
    }
    function isEventTarget(sourceObj) {
        return sourceObj && typeof sourceObj.addEventListener === 'function' && typeof sourceObj.removeEventListener === 'function';
    }

    function fromEventPattern(addHandler, removeHandler, resultSelector) {
        if (resultSelector) {
            return fromEventPattern(addHandler, removeHandler).pipe(mapOneOrManyArgs(resultSelector));
        }
        return new Observable(function (subscriber) {
            var handler = function () {
                var e = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    e[_i] = arguments[_i];
                }
                return subscriber.next(e.length === 1 ? e[0] : e);
            };
            var retValue;
            try {
                retValue = addHandler(handler);
            }
            catch (err) {
                subscriber.error(err);
                return undefined;
            }
            if (!isFunction(removeHandler)) {
                return undefined;
            }
            return function () { return removeHandler(handler, retValue); };
        });
    }

    function generate(initialStateOrOptions, condition, iterate, resultSelectorOrScheduler, scheduler) {
        var resultSelector;
        var initialState;
        if (arguments.length == 1) {
            var options = initialStateOrOptions;
            initialState = options.initialState;
            condition = options.condition;
            iterate = options.iterate;
            resultSelector = options.resultSelector || identity;
            scheduler = options.scheduler;
        }
        else {
            initialState = initialStateOrOptions;
            if (!resultSelectorOrScheduler || isScheduler(resultSelectorOrScheduler)) {
                resultSelector = identity;
                scheduler = resultSelectorOrScheduler;
            }
            else {
                resultSelector = resultSelectorOrScheduler;
            }
        }
        return new Observable(function (subscriber) {
            var state = initialState;
            if (scheduler) {
                var needIterate_1 = false;
                return scheduler.schedule(function () {
                    if (!subscriber.closed) {
                        try {
                            needIterate_1 ? (state = iterate(state)) : (needIterate_1 = true);
                            condition && !condition(state) ? subscriber.complete() : subscriber.next(resultSelector(state));
                        }
                        catch (err) {
                            subscriber.error(err);
                        }
                        if (!subscriber.closed) {
                            this.schedule(state);
                        }
                    }
                });
            }
            try {
                do {
                    if (condition && !condition(state)) {
                        subscriber.complete();
                    }
                    else {
                        subscriber.next(resultSelector(state));
                        !subscriber.closed && (state = iterate(state));
                    }
                } while (!subscriber.closed);
            }
            catch (err) {
                subscriber.error(err);
            }
            return undefined;
        });
    }

    function iif(condition, trueResult, falseResult) {
        if (trueResult === void 0) { trueResult = EMPTY; }
        if (falseResult === void 0) { falseResult = EMPTY; }
        return defer(function () { return condition() ? trueResult : falseResult; });
    }

    function isNumeric(val) {
        return !Array.isArray(val) && (val - parseFloat(val) + 1) >= 0;
    }

    function interval(period, scheduler) {
        if (period === void 0) { period = 0; }
        if (scheduler === void 0) { scheduler = async; }
        if (!isNumeric(period) || period < 0) {
            period = 0;
        }
        if (!scheduler || typeof scheduler.schedule !== 'function') {
            scheduler = async;
        }
        return new Observable(function (subscriber) {
            subscriber.add(scheduler.schedule(dispatch, period, { subscriber: subscriber, counter: 0, period: period }));
            return subscriber;
        });
    }
    function dispatch(state) {
        var subscriber = state.subscriber, counter = state.counter, period = state.period;
        subscriber.next(counter);
        this.schedule({ subscriber: subscriber, counter: counter + 1, period: period }, period);
    }

    var isArray$2 = Array.isArray;
    function argsOrArgArray(args) {
        return args.length === 1 && isArray$2(args[0]) ? args[0] : args;
    }

    function merge() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var concurrent = Infinity;
        var scheduler = undefined;
        if (isScheduler(args[args.length - 1])) {
            scheduler = args.pop();
        }
        if (typeof args[args.length - 1] === 'number') {
            concurrent = args.pop();
        }
        args = argsOrArgArray(args);
        return !args.length
            ?
                EMPTY
            : args.length === 1
                ?
                    from(args[0])
                :
                    mergeAll(concurrent)(fromArray(args, scheduler));
    }

    var NEVER = new Observable(noop);
    function never() {
        return NEVER;
    }

    function onErrorResumeNext() {
        var nextSources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            nextSources[_i] = arguments[_i];
        }
        nextSources = argsOrArgArray(nextSources);
        return operate(function (source, subscriber) {
            var remaining = __spreadArrays([source], nextSources);
            var subscribeNext = function () {
                if (!subscriber.closed) {
                    if (remaining.length > 0) {
                        var nextSource = void 0;
                        try {
                            nextSource = from(remaining.shift());
                        }
                        catch (err) {
                            subscribeNext();
                            return;
                        }
                        var innerSub = new OperatorSubscriber(subscriber, undefined, noop, noop);
                        subscriber.add(nextSource.subscribe(innerSub));
                        innerSub.add(subscribeNext);
                    }
                    else {
                        subscriber.complete();
                    }
                }
            };
            subscribeNext();
        });
    }

    function onErrorResumeNext$1() {
        var sources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sources[_i] = arguments[_i];
        }
        return onErrorResumeNext(argsOrArgArray(sources))(EMPTY);
    }

    function pairs(obj, scheduler) {
        if (!scheduler) {
            return new Observable(function (subscriber) {
                var keys = Object.keys(obj);
                for (var i = 0; i < keys.length && !subscriber.closed; i++) {
                    var key = keys[i];
                    if (obj.hasOwnProperty(key)) {
                        subscriber.next([key, obj[key]]);
                    }
                }
                subscriber.complete();
            });
        }
        else {
            return new Observable(function (subscriber) {
                var keys = Object.keys(obj);
                var subscription = new Subscription();
                subscription.add(scheduler.schedule(dispatch$1, 0, { keys: keys, index: 0, subscriber: subscriber, subscription: subscription, obj: obj }));
                return subscription;
            });
        }
    }
    function dispatch$1(state) {
        var keys = state.keys, index = state.index, subscriber = state.subscriber, subscription = state.subscription, obj = state.obj;
        if (!subscriber.closed) {
            if (index < keys.length) {
                var key = keys[index];
                subscriber.next([key, obj[key]]);
                subscription.add(this.schedule({ keys: keys, index: index + 1, subscriber: subscriber, subscription: subscription, obj: obj }));
            }
            else {
                subscriber.complete();
            }
        }
    }

    function not(pred, thisArg) {
        return function (value, index) { return !pred.call(thisArg, value, index); };
    }

    function filter(predicate, thisArg) {
        return operate(function (source, subscriber) {
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return predicate.call(thisArg, value, index++) && subscriber.next(value); }));
        });
    }

    function partition(source, predicate, thisArg) {
        return [
            filter(predicate, thisArg)(from(source)),
            filter(not(predicate, thisArg))(from(source))
        ];
    }

    function race() {
        var sources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sources[_i] = arguments[_i];
        }
        sources = argsOrArgArray(sources);
        return sources.length === 1 ? from(sources[0]) : new Observable(raceInit(sources));
    }
    function raceInit(sources) {
        return function (subscriber) {
            var subscriptions = [];
            var _loop_1 = function (i) {
                subscriptions.push(from(sources[i]).subscribe(new OperatorSubscriber(subscriber, function (value) {
                    if (subscriptions) {
                        for (var s = 0; s < subscriptions.length; s++) {
                            s !== i && subscriptions[s].unsubscribe();
                        }
                        subscriptions = null;
                    }
                    subscriber.next(value);
                })));
            };
            for (var i = 0; subscriptions && !subscriber.closed && i < sources.length; i++) {
                _loop_1(i);
            }
        };
    }

    function range(start, count, scheduler) {
        if (start === void 0) { start = 0; }
        return new Observable(function (subscriber) {
            if (count === undefined) {
                count = start;
                start = 0;
            }
            var index = 0;
            var current = start;
            if (scheduler) {
                return scheduler.schedule(dispatch$2, 0, {
                    index: index, count: count, start: start, subscriber: subscriber
                });
            }
            else {
                do {
                    if (index++ >= count) {
                        subscriber.complete();
                        break;
                    }
                    subscriber.next(current++);
                    if (subscriber.closed) {
                        break;
                    }
                } while (true);
            }
            return undefined;
        });
    }
    function dispatch$2(state) {
        var start = state.start, index = state.index, count = state.count, subscriber = state.subscriber;
        if (index >= count) {
            subscriber.complete();
            return;
        }
        subscriber.next(start);
        if (subscriber.closed) {
            return;
        }
        state.index = index + 1;
        state.start = start + 1;
        this.schedule(state);
    }

    function timer(dueTime, periodOrScheduler, scheduler) {
        if (dueTime === void 0) { dueTime = 0; }
        var period = -1;
        if (periodOrScheduler != null) {
            if (isScheduler(periodOrScheduler)) {
                scheduler = periodOrScheduler;
            }
            else {
                period = periodOrScheduler;
            }
        }
        if (!isScheduler(scheduler)) {
            scheduler = async;
        }
        return new Observable(function (subscriber) {
            var due = Math.max(0, isValidDate(dueTime) ? +dueTime - scheduler.now() : dueTime);
            return scheduler.schedule(dispatch$3, due, {
                counter: 0,
                period: period,
                subscriber: subscriber,
            });
        });
    }
    function dispatch$3(state) {
        var period = state.period, subscriber = state.subscriber;
        var counter = state.counter++;
        subscriber.next(counter);
        if (!subscriber.closed) {
            if (period < 0) {
                return subscriber.complete();
            }
            this.schedule(state, period);
        }
    }

    function using(resourceFactory, observableFactory) {
        return new Observable(function (subscriber) {
            var resource;
            try {
                resource = resourceFactory();
            }
            catch (err) {
                subscriber.error(err);
                return undefined;
            }
            var result;
            try {
                result = observableFactory(resource);
            }
            catch (err) {
                subscriber.error(err);
                return undefined;
            }
            var source = result ? from(result) : EMPTY;
            var subscription = source.subscribe(subscriber);
            return function () {
                subscription.unsubscribe();
                if (resource) {
                    resource.unsubscribe();
                }
            };
        });
    }

    function zip() {
        var sources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sources[_i] = arguments[_i];
        }
        var resultSelector = undefined;
        if (typeof sources[sources.length - 1] === 'function') {
            resultSelector = sources.pop();
        }
        return new Observable(function (subscriber) {
            var buffers = sources.map(function () { return []; });
            var completed = sources.map(function () { return false; });
            var subscription = new Subscription();
            var tryEmit = function () {
                if (buffers.every(function (buffer) { return buffer.length > 0; })) {
                    var result = buffers.map(function (buffer) { return buffer.shift(); });
                    if (resultSelector) {
                        try {
                            result = resultSelector.apply(void 0, result);
                        }
                        catch (err) {
                            subscriber.error(err);
                            return;
                        }
                    }
                    subscriber.next(result);
                    if (buffers.some(function (buffer, i) { return buffer.length === 0 && completed[i]; })) {
                        subscriber.complete();
                    }
                }
            };
            var _loop_1 = function (i) {
                var source = from(sources[i]);
                subscription.add(source.subscribe({
                    next: function (value) {
                        buffers[i].push(value);
                        tryEmit();
                    },
                    error: function (err) { return subscriber.error(err); },
                    complete: function () {
                        completed[i] = true;
                        if (buffers[i].length === 0) {
                            subscriber.complete();
                        }
                    },
                }));
            };
            for (var i = 0; !subscriber.closed && i < sources.length; i++) {
                _loop_1(i);
            }
            return subscription;
        });
    }

    function audit(durationSelector) {
        return operate(function (source, subscriber) {
            var hasValue = false;
            var lastValue = null;
            var durationSubscriber = null;
            var endDuration = function () {
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                durationSubscriber = null;
                if (hasValue) {
                    hasValue = false;
                    var value = lastValue;
                    lastValue = null;
                    subscriber.next(value);
                }
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                hasValue = true;
                lastValue = value;
                if (!durationSubscriber) {
                    from(durationSelector(value)).subscribe((durationSubscriber = new OperatorSubscriber(subscriber, endDuration, undefined, endDuration)));
                }
            }));
        });
    }

    function auditTime(duration, scheduler) {
        if (scheduler === void 0) { scheduler = async; }
        return audit(function () { return timer(duration, scheduler); });
    }

    function buffer(closingNotifier) {
        return operate(function (source, subscriber) {
            var buffer = [];
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return buffer.push(value); }));
            closingNotifier.subscribe(new OperatorSubscriber(subscriber, function () {
                var b = buffer;
                buffer = [];
                subscriber.next(b);
            }));
            return function () {
                buffer = null;
            };
        });
    }

    function bufferCount(bufferSize, startBufferEvery) {
        if (startBufferEvery === void 0) { startBufferEvery = null; }
        startBufferEvery = startBufferEvery !== null && startBufferEvery !== void 0 ? startBufferEvery : bufferSize;
        return operate(function (source, subscriber) {
            var buffers = [];
            var count = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var toEmit = null;
                if (count++ % startBufferEvery === 0) {
                    buffers.push([]);
                }
                for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
                    var buffer = buffers_1[_i];
                    buffer.push(value);
                    if (bufferSize <= buffer.length) {
                        toEmit = toEmit !== null && toEmit !== void 0 ? toEmit : [];
                        toEmit.push(buffer);
                    }
                }
                if (toEmit) {
                    for (var _a = 0, toEmit_1 = toEmit; _a < toEmit_1.length; _a++) {
                        var buffer = toEmit_1[_a];
                        arrRemove(buffers, buffer);
                        subscriber.next(buffer);
                    }
                }
            }, undefined, function () {
                for (var _i = 0, buffers_2 = buffers; _i < buffers_2.length; _i++) {
                    var buffer = buffers_2[_i];
                    subscriber.next(buffer);
                }
                subscriber.complete();
            }, function () {
                buffers = null;
            }));
        });
    }

    function bufferTime(bufferTimeSpan) {
        var _a;
        var otherArgs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            otherArgs[_i - 1] = arguments[_i];
        }
        var scheduler = isScheduler(otherArgs[otherArgs.length - 1]) ? otherArgs.pop() : asyncScheduler;
        var bufferCreationInterval = (_a = otherArgs[0]) !== null && _a !== void 0 ? _a : null;
        var maxBufferSize = otherArgs[1] || Infinity;
        return operate(function (source, subscriber) {
            var bufferRecords = [];
            var restartOnEmit = false;
            var emit = function (record) {
                var buffer = record.buffer, subs = record.subs;
                subs.unsubscribe();
                arrRemove(bufferRecords, record);
                subscriber.next(buffer);
                restartOnEmit && startBuffer();
            };
            var startBuffer = function () {
                if (bufferRecords) {
                    var subs = new Subscription();
                    subscriber.add(subs);
                    var buffer = [];
                    var record_1 = {
                        buffer: buffer,
                        subs: subs,
                    };
                    bufferRecords.push(record_1);
                    subs.add(scheduler.schedule(function () { return emit(record_1); }, bufferTimeSpan));
                }
            };
            bufferCreationInterval !== null && bufferCreationInterval >= 0
                ?
                    subscriber.add(scheduler.schedule(function () {
                        startBuffer();
                        !this.closed && subscriber.add(this.schedule(null, bufferCreationInterval));
                    }, bufferCreationInterval))
                : (restartOnEmit = true);
            startBuffer();
            var bufferTimeSubscriber = new OperatorSubscriber(subscriber, function (value) {
                var recordsCopy = bufferRecords.slice();
                for (var _i = 0, recordsCopy_1 = recordsCopy; _i < recordsCopy_1.length; _i++) {
                    var record = recordsCopy_1[_i];
                    var buffer = record.buffer;
                    buffer.push(value);
                    maxBufferSize <= buffer.length && emit(record);
                }
            }, undefined, function () {
                while (bufferRecords === null || bufferRecords === void 0 ? void 0 : bufferRecords.length) {
                    subscriber.next(bufferRecords.shift().buffer);
                }
                bufferTimeSubscriber === null || bufferTimeSubscriber === void 0 ? void 0 : bufferTimeSubscriber.unsubscribe();
                subscriber.complete();
                subscriber.unsubscribe();
            }, function () { return (bufferRecords = null); });
            source.subscribe(bufferTimeSubscriber);
        });
    }

    function bufferToggle(openings, closingSelector) {
        return operate(function (source, subscriber) {
            var buffers = [];
            from(openings).subscribe(new OperatorSubscriber(subscriber, function (openValue) {
                var buffer = [];
                buffers.push(buffer);
                var closingSubscription = new Subscription();
                var emit = function () {
                    arrRemove(buffers, buffer);
                    subscriber.next(buffer);
                    closingSubscription.unsubscribe();
                };
                closingSubscription.add(from(closingSelector(openValue)).subscribe(new OperatorSubscriber(subscriber, emit, undefined, emit)));
            }, undefined, noop));
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
                    var buffer = buffers_1[_i];
                    buffer.push(value);
                }
            }, undefined, function () {
                while (buffers.length > 0) {
                    subscriber.next(buffers.shift());
                }
                subscriber.complete();
            }));
        });
    }

    function bufferWhen(closingSelector) {
        return operate(function (source, subscriber) {
            var buffer = null;
            var closingSubscriber = null;
            var openBuffer = function () {
                closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
                var b = buffer;
                buffer = [];
                b && subscriber.next(b);
                var closingNotifier;
                try {
                    closingNotifier = from(closingSelector());
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                closingNotifier.subscribe((closingSubscriber = new OperatorSubscriber(subscriber, openBuffer, undefined, function () { return openBuffer(); })));
            };
            openBuffer();
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return buffer === null || buffer === void 0 ? void 0 : buffer.push(value); }, undefined, function () {
                buffer && subscriber.next(buffer);
                subscriber.complete();
            }, function () { return (buffer = closingSubscriber = null); }));
        });
    }

    function catchError(selector) {
        return operate(function (source, subscriber) {
            var innerSub = null;
            var syncUnsub = false;
            var handledResult;
            innerSub = source.subscribe(new OperatorSubscriber(subscriber, undefined, function (err) {
                handledResult = from(selector(err, catchError(selector)(source)));
                if (innerSub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    handledResult.subscribe(subscriber);
                }
                else {
                    syncUnsub = true;
                }
            }));
            if (syncUnsub) {
                innerSub.unsubscribe();
                innerSub = null;
                handledResult.subscribe(subscriber);
            }
        });
    }

    function scan(accumulator, seed) {
        var hasSeed = arguments.length >= 2;
        return operate(function (source, subscriber) {
            var hasState = hasSeed;
            var state = seed;
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var i = index++;
                subscriber.next((state = hasState
                    ?
                        accumulator(state, value, i)
                    :
                        ((hasState = true), value)));
            }));
        });
    }

    function takeLast(count) {
        return count <= 0
            ? function () { return EMPTY; }
            : operate(function (source, subscriber) {
                var buffer = [];
                source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                    buffer.push(value);
                    count < buffer.length && buffer.shift();
                }, undefined, function () {
                    while (buffer.length) {
                        subscriber.next(buffer.shift());
                    }
                    subscriber.complete();
                    buffer = null;
                }));
            });
    }

    function defaultIfEmpty(defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        return operate(function (source, subscriber) {
            var hasValue = false;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                hasValue = true;
                subscriber.next(value);
            }, undefined, function () {
                if (!hasValue) {
                    subscriber.next(defaultValue);
                }
                subscriber.complete();
            }));
        });
    }

    function reduce(accumulator, seed) {
        if (arguments.length >= 2) {
            return function reduceOperatorFunctionWithSeed(source) {
                return pipe(scan(accumulator, seed), takeLast(1), defaultIfEmpty(seed))(source);
            };
        }
        return function reduceOperatorFunction(source) {
            return pipe(scan(function (acc, value, index) { return accumulator(acc, value, index); }), takeLast(1))(source);
        };
    }

    function toArrayReducer(arr, item, index) {
        if (index === 0) {
            return [item];
        }
        arr.push(item);
        return arr;
    }
    function toArray() {
        return reduce(toArrayReducer, []);
    }

    function concatMap(project, resultSelector) {
        if (typeof resultSelector === 'function') {
            return mergeMap(project, resultSelector, 1);
        }
        return mergeMap(project, 1);
    }

    function combineAll(project) {
        return function (source) { return source.pipe(toArray(), concatMap(function (sources) { return combineLatest(sources); }), project ? mapOneOrManyArgs(project) : identity); };
    }

    function combineLatest$1() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var project = undefined;
        if (typeof args[args.length - 1] === 'function') {
            project = args.pop();
            return pipe(combineLatest$1.apply(void 0, args), mapOneOrManyArgs(project));
        }
        return operate(function (source, subscriber) {
            return combineLatestInit(__spreadArrays([source], argsOrArgArray(args)))(subscriber);
        });
    }
    function combineLatestWith() {
        var otherSources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            otherSources[_i] = arguments[_i];
        }
        return combineLatest$1.apply(void 0, otherSources);
    }

    function concatMapTo(innerObservable, resultSelector) {
        if (typeof resultSelector === 'function') {
            return concatMap(function () { return innerObservable; }, resultSelector);
        }
        return concatMap(function () { return innerObservable; });
    }

    function concatWith() {
        var otherSources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            otherSources[_i] = arguments[_i];
        }
        return concat$1.apply(void 0, otherSources);
    }
    function concat$1() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var scheduler;
        if (isScheduler(args[args.length - 1])) {
            scheduler = args.pop();
        }
        return operate(function (source, subscriber) {
            concatAll()(fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
        });
    }

    function count(predicate) {
        return operate(function (source, subscriber) {
            var index = 0;
            var count = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (!predicate || predicate(value, index++, source)) && count++; }, undefined, function () {
                subscriber.next(count);
                subscriber.complete();
            }));
        });
    }

    function debounce(durationSelector) {
        return operate(function (source, subscriber) {
            var hasValue = false;
            var lastValue = null;
            var durationSubscriber = null;
            var emit = function () {
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                durationSubscriber = null;
                if (hasValue) {
                    hasValue = false;
                    var value = lastValue;
                    lastValue = null;
                    subscriber.next(value);
                }
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                hasValue = true;
                lastValue = value;
                durationSubscriber = new OperatorSubscriber(subscriber, emit, undefined, emit);
                from(durationSelector(value)).subscribe(durationSubscriber);
            }, undefined, function () {
                emit();
                subscriber.complete();
            }, function () {
                lastValue = durationSubscriber = null;
            }));
        });
    }

    function debounceTime(dueTime, scheduler) {
        if (scheduler === void 0) { scheduler = asyncScheduler; }
        return operate(function (source, subscriber) {
            var hasValue = false;
            var lastValue = null;
            var debounceSubscription = null;
            var emitLastValue = function () {
                hasValue = false;
                var value = lastValue;
                lastValue = null;
                subscriber.next(value);
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                debounceSubscription === null || debounceSubscription === void 0 ? void 0 : debounceSubscription.unsubscribe();
                hasValue = true;
                lastValue = value;
                subscriber.add((debounceSubscription = scheduler.schedule(function () {
                    debounceSubscription = null;
                    emitLastValue();
                }, dueTime)));
            }, undefined, function () {
                hasValue && emitLastValue();
                subscriber.complete();
            }));
        });
    }

    function delay(delay, scheduler) {
        if (scheduler === void 0) { scheduler = asyncScheduler; }
        return operate(function (source, subscriber) {
            var isAbsoluteDelay = isValidDate(delay);
            var isComplete = false;
            var active = 0;
            var absoluteTimeValues = isAbsoluteDelay ? [] : null;
            var checkComplete = function () { return isComplete && !active && !(absoluteTimeValues === null || absoluteTimeValues === void 0 ? void 0 : absoluteTimeValues.length) && subscriber.complete(); };
            if (isAbsoluteDelay) {
                active++;
                subscriber.add(scheduler.schedule(function () {
                    active--;
                    if (absoluteTimeValues) {
                        var values = absoluteTimeValues;
                        absoluteTimeValues = null;
                        for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
                            var value = values_1[_i];
                            subscriber.next(value);
                        }
                    }
                    checkComplete();
                }, +delay - scheduler.now()));
            }
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                if (isAbsoluteDelay) {
                    absoluteTimeValues ? absoluteTimeValues.push(value) : subscriber.next(value);
                }
                else {
                    active++;
                    subscriber.add(scheduler.schedule(function () {
                        active--;
                        subscriber.next(value);
                        checkComplete();
                    }, delay));
                }
            }, undefined, function () {
                isComplete = true;
                checkComplete();
            }));
            return function () {
                absoluteTimeValues = null;
            };
        });
    }

    function take(count) {
        return count <= 0
            ? function () { return EMPTY; }
            : operate(function (source, subscriber) {
                var seen = 0;
                source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                    if (++seen <= count) {
                        subscriber.next(value);
                        if (count <= seen) {
                            subscriber.complete();
                        }
                    }
                }));
            });
    }

    function ignoreElements() {
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, noop));
        });
    }

    function delayWhen(delayDurationSelector, subscriptionDelay) {
        if (subscriptionDelay) {
            return function (source) {
                return concat(subscriptionDelay.pipe(take(1), ignoreElements()), source.pipe(delayWhen(delayDurationSelector)));
            };
        }
        return operate(function (source, subscriber) {
            var index = 0;
            var isComplete = false;
            var active = 0;
            var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var closed = false;
                var notify = function () {
                    subscriber.next(value);
                    durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                    if (!closed) {
                        active--;
                        closed = true;
                        checkComplete();
                    }
                };
                var durationSubscriber = new OperatorSubscriber(subscriber, notify, undefined, notify);
                active++;
                delayDurationSelector(value, index++).subscribe(durationSubscriber);
            }, undefined, function () {
                isComplete = true;
                checkComplete();
            }));
        });
    }

    function dematerialize() {
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, function (notification) { return observeNotification(notification, subscriber); }));
        });
    }

    function distinct(keySelector, flushes) {
        return operate(function (source, subscriber) {
            var distinctKeys = new Set();
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var key = keySelector ? keySelector(value) : value;
                if (!distinctKeys.has(key)) {
                    distinctKeys.add(key);
                    subscriber.next(value);
                }
            }));
            flushes === null || flushes === void 0 ? void 0 : flushes.subscribe(new OperatorSubscriber(subscriber, function () { return distinctKeys.clear(); }, undefined, noop));
        });
    }

    function distinctUntilChanged(compare, keySelector) {
        compare = compare !== null && compare !== void 0 ? compare : defaultCompare;
        return operate(function (source, subscriber) {
            var prev;
            var first = true;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                ((first && ((prev = value), 1)) || !compare(prev, (prev = keySelector ? keySelector(value) : value))) &&
                    subscriber.next(value);
                first = false;
            }));
        });
    }
    function defaultCompare(a, b) {
        return a === b;
    }

    function distinctUntilKeyChanged(key, compare) {
        return distinctUntilChanged(function (x, y) { return compare ? compare(x[key], y[key]) : x[key] === y[key]; });
    }

    function throwIfEmpty(errorFactory) {
        if (errorFactory === void 0) { errorFactory = defaultErrorFactory; }
        return operate(function (source, subscriber) {
            var hasValue = false;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                hasValue = true;
                subscriber.next(value);
            }, undefined, function () { return (hasValue ? subscriber.complete() : subscriber.error(errorFactory())); }));
        });
    }
    function defaultErrorFactory() {
        return new EmptyError();
    }

    function elementAt(index, defaultValue) {
        if (index < 0) {
            throw new ArgumentOutOfRangeError();
        }
        var hasDefaultValue = arguments.length >= 2;
        return function (source) { return source.pipe(filter(function (v, i) { return i === index; }), take(1), hasDefaultValue
            ? defaultIfEmpty(defaultValue)
            : throwIfEmpty(function () { return new ArgumentOutOfRangeError(); })); };
    }

    function endWith() {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        return function (source) { return concat(source, of.apply(void 0, values)); };
    }

    function every(predicate, thisArg) {
        return operate(function (source, subscriber) {
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                if (!predicate.call(thisArg, value, index, source)) {
                    subscriber.next(false);
                    subscriber.complete();
                }
            }, undefined, function () {
                subscriber.next(true);
                subscriber.complete();
            }));
        });
    }

    function exhaust() {
        return operate(function (source, subscriber) {
            var isComplete = false;
            var innerSub = null;
            source.subscribe(new OperatorSubscriber(subscriber, function (inner) {
                if (!innerSub) {
                    innerSub = from(inner).subscribe(new OperatorSubscriber(subscriber, undefined, undefined, function () {
                        innerSub = null;
                        isComplete && subscriber.complete();
                    }));
                }
            }, undefined, function () {
                isComplete = true;
                !innerSub && subscriber.complete();
            }));
        });
    }

    function exhaustMap(project, resultSelector) {
        if (resultSelector) {
            return function (source) {
                return source.pipe(exhaustMap(function (a, i) { return from(project(a, i)).pipe(map(function (b, ii) { return resultSelector(a, b, i, ii); })); }));
            };
        }
        return operate(function (source, subscriber) {
            var index = 0;
            var innerSub = null;
            var isComplete = false;
            source.subscribe(new OperatorSubscriber(subscriber, function (outerValue) {
                if (!innerSub) {
                    innerSub = new OperatorSubscriber(subscriber, undefined, undefined, function () {
                        innerSub = null;
                        isComplete && subscriber.complete();
                    });
                    from(project(outerValue, index++)).subscribe(innerSub);
                }
            }, undefined, function () {
                isComplete = true;
                !innerSub && subscriber.complete();
            }));
        });
    }

    function expand(project, concurrent, scheduler) {
        if (concurrent === void 0) { concurrent = Infinity; }
        concurrent = (concurrent || 0) < 1 ? Infinity : concurrent;
        return operate(function (source, subscriber) {
            var active = 0;
            var buffer = [];
            var index = 0;
            var isComplete = false;
            var emitAndExpand = function (value) {
                subscriber.next(value);
                var inner = from(project(value, index++));
                active++;
                var doSub = function () {
                    inner.subscribe(new OperatorSubscriber(subscriber, next, undefined, function () {
                        --active === 0 && isComplete && !buffer.length ? subscriber.complete() : trySub();
                    }));
                };
                scheduler ? subscriber.add(scheduler.schedule(doSub)) : doSub();
            };
            var trySub = function () {
                while (0 < buffer.length && active < concurrent) {
                    emitAndExpand(buffer.shift());
                }
            };
            var next = function (value) { return (active < concurrent ? emitAndExpand(value) : buffer.push(value)); };
            source.subscribe(new OperatorSubscriber(subscriber, next, undefined, function () {
                isComplete = true;
                active === 0 && subscriber.complete();
            }));
            return function () {
                buffer = null;
            };
        });
    }

    function finalize(callback) {
        return operate(function (source, subscriber) {
            source.subscribe(subscriber);
            subscriber.add(callback);
        });
    }

    function find(predicate, thisArg) {
        return operate(createFind(predicate, thisArg, 'value'));
    }
    function createFind(predicate, thisArg, emit) {
        var findIndex = emit === 'index';
        return function (source, subscriber) {
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var i = index++;
                if (predicate.call(thisArg, value, i, source)) {
                    subscriber.next(findIndex ? i : value);
                    subscriber.complete();
                }
            }, undefined, function () {
                subscriber.next(findIndex ? -1 : undefined);
                subscriber.complete();
            }));
        };
    }

    function findIndex(predicate, thisArg) {
        return operate(createFind(predicate, thisArg, 'index'));
    }

    function first(predicate, defaultValue) {
        var hasDefaultValue = arguments.length >= 2;
        return function (source) { return source.pipe(predicate ? filter(function (v, i) { return predicate(v, i, source); }) : identity, take(1), hasDefaultValue ? defaultIfEmpty(defaultValue) : throwIfEmpty(function () { return new EmptyError(); })); };
    }

    function groupBy(keySelector, elementSelector, durationSelector, subjectSelector) {
        return operate(function (source, subscriber) {
            var groups = new Map();
            var notify = function (cb) {
                groups.forEach(cb);
                cb(subscriber);
            };
            var groupBySourceSubscriber = new GroupBySubscriber(subscriber, function (value) {
                var key = keySelector(value);
                var group = groups.get(key);
                if (!group) {
                    groups.set(key, (group = subjectSelector ? subjectSelector() : new Subject()));
                    var grouped = createGroupedObservable(key, group);
                    subscriber.next(grouped);
                    if (durationSelector) {
                        var durationSubscriber_1 = new OperatorSubscriber(group, function () {
                            group.complete();
                            durationSubscriber_1 === null || durationSubscriber_1 === void 0 ? void 0 : durationSubscriber_1.unsubscribe();
                        }, undefined, undefined, function () { return groups.delete(key); });
                        groupBySourceSubscriber.add(durationSelector(grouped).subscribe(durationSubscriber_1));
                    }
                }
                group.next(elementSelector ? elementSelector(value) : value);
            }, function (err) { return notify(function (consumer) { return consumer.error(err); }); }, function () { return notify(function (consumer) { return consumer.complete(); }); }, function () { return groups.clear(); });
            source.subscribe(groupBySourceSubscriber);
            function createGroupedObservable(key, groupSubject) {
                var result = new Observable(function (groupSubscriber) {
                    groupBySourceSubscriber.activeGroups++;
                    var innerSub = groupSubject.subscribe(groupSubscriber);
                    return function () {
                        innerSub.unsubscribe();
                        --groupBySourceSubscriber.activeGroups === 0 &&
                            groupBySourceSubscriber.teardownAttempted &&
                            groupBySourceSubscriber.unsubscribe();
                    };
                });
                result.key = key;
                return result;
            }
        });
    }
    var GroupBySubscriber = (function (_super) {
        __extends(GroupBySubscriber, _super);
        function GroupBySubscriber() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.activeGroups = 0;
            _this.teardownAttempted = false;
            return _this;
        }
        GroupBySubscriber.prototype.unsubscribe = function () {
            this.teardownAttempted = true;
            this.activeGroups === 0 && _super.prototype.unsubscribe.call(this);
        };
        return GroupBySubscriber;
    }(OperatorSubscriber));

    function isEmpty() {
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, function () {
                subscriber.next(false);
                subscriber.complete();
            }, undefined, function () {
                subscriber.next(true);
                subscriber.complete();
            }));
        });
    }

    function last(predicate, defaultValue) {
        var hasDefaultValue = arguments.length >= 2;
        return function (source) { return source.pipe(predicate ? filter(function (v, i) { return predicate(v, i, source); }) : identity, takeLast(1), hasDefaultValue ? defaultIfEmpty(defaultValue) : throwIfEmpty(function () { return new EmptyError(); })); };
    }

    function mapTo(value) {
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, function () { return subscriber.next(value); }));
        });
    }

    function materialize() {
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                subscriber.next(Notification.createNext(value));
            }, function (err) {
                subscriber.next(Notification.createError(err));
                subscriber.complete();
            }, function () {
                subscriber.next(Notification.createComplete());
                subscriber.complete();
            }));
        });
    }

    function max(comparer) {
        var max = (typeof comparer === 'function')
            ? function (x, y) { return comparer(x, y) > 0 ? x : y; }
            : function (x, y) { return x > y ? x : y; };
        return reduce(max);
    }

    function merge$1() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var concurrent = Infinity;
        var scheduler = undefined;
        if (isScheduler(args[args.length - 1])) {
            scheduler = args.pop();
        }
        if (typeof args[args.length - 1] === 'number') {
            concurrent = args.pop();
        }
        args = argsOrArgArray(args);
        return operate(function (source, subscriber) {
            mergeAll(concurrent)(fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
        });
    }
    function mergeWith() {
        var otherSources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            otherSources[_i] = arguments[_i];
        }
        return merge$1.apply(void 0, otherSources);
    }

    function mergeMapTo(innerObservable, resultSelector, concurrent) {
        if (concurrent === void 0) { concurrent = Infinity; }
        if (typeof resultSelector === 'function') {
            return mergeMap(function () { return innerObservable; }, resultSelector, concurrent);
        }
        if (typeof resultSelector === 'number') {
            concurrent = resultSelector;
        }
        return mergeMap(function () { return innerObservable; }, concurrent);
    }

    function mergeScan(accumulator, seed, concurrent) {
        if (concurrent === void 0) { concurrent = Infinity; }
        return operate(function (source, subscriber) {
            var buffer = [];
            var active = 0;
            var hasState = false;
            var state = seed;
            var index = 0;
            var isComplete = false;
            var checkComplete = function () {
                if (isComplete && !buffer.length && !active) {
                    !hasState && subscriber.next(state);
                    subscriber.complete();
                }
            };
            var doInnerSub = function (value) {
                active++;
                from(accumulator(state, value, index++)).subscribe(new OperatorSubscriber(subscriber, function (innerValue) {
                    hasState = true;
                    subscriber.next((state = innerValue));
                }, undefined, function () {
                    active--;
                    buffer.length && tryInnerSub();
                    checkComplete();
                }));
            };
            var tryInnerSub = function () {
                while (buffer.length && active < concurrent) {
                    doInnerSub(buffer.shift());
                }
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
                isComplete = true;
                checkComplete();
            }));
            return function () {
                buffer = null;
            };
        });
    }

    function min(comparer) {
        var min = (typeof comparer === 'function')
            ? function (x, y) { return comparer(x, y) < 0 ? x : y; }
            : function (x, y) { return x < y ? x : y; };
        return reduce(min);
    }

    function multicast(subjectOrSubjectFactory, selector) {
        var subjectFactory = typeof subjectOrSubjectFactory === 'function' ? subjectOrSubjectFactory : function () { return subjectOrSubjectFactory; };
        if (typeof selector === 'function') {
            return operate(function (source, subscriber) {
                var subject = subjectFactory();
                selector(subject).subscribe(subscriber).add(source.subscribe(subject));
            });
        }
        return function (source) {
            var connectable = new ConnectableObservable(source, subjectFactory);
            if (hasLift(source)) {
                connectable.lift = source.lift;
            }
            connectable.source = source;
            connectable.subjectFactory = subjectFactory;
            return connectable;
        };
    }

    function observeOn(scheduler, delay) {
        if (delay === void 0) { delay = 0; }
        return operate(function (source, subscriber) {
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return subscriber.add(scheduler.schedule(function () { return subscriber.next(value); }, delay)); }, function (err) { return subscriber.add(scheduler.schedule(function () { return subscriber.error(err); }, delay)); }, function () { return subscriber.add(scheduler.schedule(function () { return subscriber.complete(); }, delay)); }));
        });
    }

    function pairwise() {
        return operate(function (source, subscriber) {
            var prev;
            var hasPrev = false;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var p = prev;
                prev = value;
                hasPrev && subscriber.next([p, value]);
                hasPrev = true;
            }));
        });
    }

    function partition$1(predicate, thisArg) {
        return function (source) { return [
            filter(predicate, thisArg)(source),
            filter(not(predicate, thisArg))(source)
        ]; };
    }

    function pluck() {
        var properties = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            properties[_i] = arguments[_i];
        }
        var length = properties.length;
        if (length === 0) {
            throw new Error('list of properties cannot be empty.');
        }
        return map(function (x) {
            var currentProp = x;
            for (var i = 0; i < length; i++) {
                var p = currentProp === null || currentProp === void 0 ? void 0 : currentProp[properties[i]];
                if (typeof p !== 'undefined') {
                    currentProp = p;
                }
                else {
                    return undefined;
                }
            }
            return currentProp;
        });
    }

    function publish(selector) {
        return selector ?
            multicast(function () { return new Subject(); }, selector) :
            multicast(new Subject());
    }

    function publishBehavior(value) {
        return function (source) { return multicast(new BehaviorSubject(value))(source); };
    }

    function publishLast() {
        return function (source) { return multicast(new AsyncSubject())(source); };
    }

    function publishReplay(bufferSize, windowTime, selectorOrScheduler, scheduler) {
        if (selectorOrScheduler && typeof selectorOrScheduler !== 'function') {
            scheduler = selectorOrScheduler;
        }
        var selector = typeof selectorOrScheduler === 'function' ? selectorOrScheduler : undefined;
        var subject = new ReplaySubject(bufferSize, windowTime, scheduler);
        return function (source) { return multicast(function () { return subject; }, selector)(source); };
    }

    function race$1() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return raceWith.apply(void 0, argsOrArgArray(args));
    }
    function raceWith() {
        var otherSources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            otherSources[_i] = arguments[_i];
        }
        return !otherSources.length ? identity : operate(function (source, subscriber) {
            raceInit(__spreadArrays([source], otherSources))(subscriber);
        });
    }

    function repeat(count) {
        if (count === void 0) { count = Infinity; }
        return count <= 0
            ? function () { return EMPTY; }
            : operate(function (source, subscriber) {
                var soFar = 0;
                var innerSub;
                var subscribeForRepeat = function () {
                    var syncUnsub = false;
                    innerSub = source.subscribe(new OperatorSubscriber(subscriber, undefined, undefined, function () {
                        if (++soFar < count) {
                            if (innerSub) {
                                innerSub.unsubscribe();
                                innerSub = null;
                                subscribeForRepeat();
                            }
                            else {
                                syncUnsub = true;
                            }
                        }
                        else {
                            subscriber.complete();
                        }
                    }));
                    if (syncUnsub) {
                        innerSub.unsubscribe();
                        innerSub = null;
                        subscribeForRepeat();
                    }
                };
                subscribeForRepeat();
            });
    }

    function repeatWhen(notifier) {
        return operate(function (source, subscriber) {
            var innerSub;
            var syncResub = false;
            var completions$;
            var isNotifierComplete = false;
            var isMainComplete = false;
            var checkComplete = function () { return isMainComplete && isNotifierComplete && (subscriber.complete(), true); };
            var getCompletionSubject = function () {
                if (!completions$) {
                    completions$ = new Subject();
                    notifier(completions$).subscribe(new OperatorSubscriber(subscriber, function () {
                        if (innerSub) {
                            subscribeForRepeatWhen();
                        }
                        else {
                            syncResub = true;
                        }
                    }, undefined, function () {
                        isNotifierComplete = true;
                        checkComplete();
                    }));
                }
                return completions$;
            };
            var subscribeForRepeatWhen = function () {
                isMainComplete = false;
                innerSub = source.subscribe(new OperatorSubscriber(subscriber, undefined, undefined, function () {
                    isMainComplete = true;
                    !checkComplete() && getCompletionSubject().next();
                }));
                if (syncResub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    syncResub = false;
                    subscribeForRepeatWhen();
                }
            };
            subscribeForRepeatWhen();
        });
    }

    function retry(configOrCount) {
        if (configOrCount === void 0) { configOrCount = Infinity; }
        var config;
        if (configOrCount && typeof configOrCount === 'object') {
            config = configOrCount;
        }
        else {
            config = {
                count: configOrCount,
            };
        }
        var count = config.count, _a = config.resetOnSuccess, resetOnSuccess = _a === void 0 ? false : _a;
        return count <= 0
            ? function () { return EMPTY; }
            : operate(function (source, subscriber) {
                var soFar = 0;
                var innerSub;
                var subscribeForRetry = function () {
                    var syncUnsub = false;
                    innerSub = source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                        if (resetOnSuccess) {
                            soFar = 0;
                        }
                        subscriber.next(value);
                    }, function (err) {
                        if (soFar++ < count) {
                            if (innerSub) {
                                innerSub.unsubscribe();
                                innerSub = null;
                                subscribeForRetry();
                            }
                            else {
                                syncUnsub = true;
                            }
                        }
                        else {
                            subscriber.error(err);
                        }
                    }));
                    if (syncUnsub) {
                        innerSub.unsubscribe();
                        innerSub = null;
                        subscribeForRetry();
                    }
                };
                subscribeForRetry();
            });
    }

    function retryWhen(notifier) {
        return operate(function (source, subscriber) {
            var innerSub;
            var syncResub = false;
            var errors$;
            var subscribeForRetryWhen = function () {
                innerSub = source.subscribe(new OperatorSubscriber(subscriber, undefined, function (err) {
                    if (!errors$) {
                        errors$ = new Subject();
                        notifier(errors$).subscribe(new OperatorSubscriber(subscriber, function () {
                            return innerSub ? subscribeForRetryWhen() : (syncResub = true);
                        }));
                    }
                    if (errors$) {
                        errors$.next(err);
                    }
                }));
                if (syncResub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    syncResub = false;
                    subscribeForRetryWhen();
                }
            };
            subscribeForRetryWhen();
        });
    }

    function sample(notifier) {
        return operate(function (source, subscriber) {
            var hasValue = false;
            var lastValue = null;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                hasValue = true;
                lastValue = value;
            }));
            var emit = function () {
                if (hasValue) {
                    hasValue = false;
                    var value = lastValue;
                    lastValue = null;
                    subscriber.next(value);
                }
            };
            notifier.subscribe(new OperatorSubscriber(subscriber, emit, undefined, emit));
        });
    }

    function sampleTime(period, scheduler) {
        if (scheduler === void 0) { scheduler = asyncScheduler; }
        return sample(interval(period, scheduler));
    }

    function sequenceEqual(compareTo, comparator) {
        if (comparator === void 0) { comparator = function (a, b) { return a === b; }; }
        return operate(function (source, subscriber) {
            var aState = createState();
            var bState = createState();
            var emit = function (isEqual) {
                subscriber.next(isEqual);
                subscriber.complete();
            };
            var createSubscriber = function (selfState, otherState) {
                var sequenceEqualSubscriber = new OperatorSubscriber(subscriber, function (a) {
                    var buffer = otherState.buffer, complete = otherState.complete;
                    if (buffer.length === 0) {
                        complete ? emit(false) : selfState.buffer.push(a);
                    }
                    else {
                        !comparator(a, buffer.shift()) && emit(false);
                    }
                }, undefined, function () {
                    selfState.complete = true;
                    var complete = otherState.complete, buffer = otherState.buffer;
                    complete && emit(buffer.length === 0);
                    sequenceEqualSubscriber === null || sequenceEqualSubscriber === void 0 ? void 0 : sequenceEqualSubscriber.unsubscribe();
                });
                return sequenceEqualSubscriber;
            };
            source.subscribe(createSubscriber(aState, bState));
            compareTo.subscribe(createSubscriber(bState, aState));
        });
    }
    function createState() {
        return {
            buffer: [],
            complete: false,
        };
    }

    function shareSubjectFactory() {
        return new Subject();
    }
    function share() {
        return function (source) { return refCount()(multicast(shareSubjectFactory)(source)); };
    }

    function shareReplay(configOrBufferSize, windowTime, scheduler) {
        var config;
        if (configOrBufferSize && typeof configOrBufferSize === 'object') {
            config = configOrBufferSize;
        }
        else {
            config = {
                bufferSize: configOrBufferSize,
                windowTime: windowTime,
                refCount: false,
                scheduler: scheduler
            };
        }
        return operate(shareReplayOperator(config));
    }
    function shareReplayOperator(_a) {
        var _b = _a.bufferSize, bufferSize = _b === void 0 ? Infinity : _b, _c = _a.windowTime, windowTime = _c === void 0 ? Infinity : _c, useRefCount = _a.refCount, scheduler = _a.scheduler;
        var subject;
        var refCount = 0;
        var subscription;
        return function (source, subscriber) {
            refCount++;
            var innerSub;
            if (!subject) {
                subject = new ReplaySubject(bufferSize, windowTime, scheduler);
                innerSub = subject.subscribe(subscriber);
                subscription = source.subscribe({
                    next: function (value) { subject.next(value); },
                    error: function (err) {
                        var dest = subject;
                        subscription = undefined;
                        subject = undefined;
                        dest.error(err);
                    },
                    complete: function () {
                        subscription = undefined;
                        subject.complete();
                    },
                });
                if (subscription.closed) {
                    subscription = undefined;
                }
            }
            else {
                innerSub = subject.subscribe(subscriber);
            }
            subscriber.add(function () {
                refCount--;
                innerSub.unsubscribe();
                if (useRefCount && refCount === 0 && subscription) {
                    subscription.unsubscribe();
                    subscription = undefined;
                    subject = undefined;
                }
            });
        };
    }

    function single(predicate) {
        return operate(function (source, subscriber) {
            var hasValue = false;
            var singleValue;
            var seenValue = false;
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                seenValue = true;
                if (!predicate || predicate(value, index++, source)) {
                    hasValue && subscriber.error(new SequenceError('Too many matching values'));
                    hasValue = true;
                    singleValue = value;
                }
            }, undefined, function () {
                if (hasValue) {
                    subscriber.next(singleValue);
                    subscriber.complete();
                }
                else {
                    subscriber.error(seenValue ? new NotFoundError('No matching values') : new EmptyError());
                }
            }));
        });
    }

    function skip(count) {
        return operate(function (source, subscriber) {
            var seen = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (count === seen ? subscriber.next(value) : seen++); }));
        });
    }

    function skipLast(skipCount) {
        return skipCount <= 0
            ? identity
            : operate(function (source, subscriber) {
                var ring = new Array(skipCount);
                var count = 0;
                source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                    var currentCount = count++;
                    if (currentCount < skipCount) {
                        ring[currentCount] = value;
                    }
                    else {
                        var index = currentCount % skipCount;
                        var oldValue = ring[index];
                        ring[index] = value;
                        subscriber.next(oldValue);
                    }
                }, undefined, undefined, function () {
                    return (ring = null);
                }));
            });
    }

    function skipUntil(notifier) {
        return operate(function (source, subscriber) {
            var taking = false;
            var skipSubscriber = new OperatorSubscriber(subscriber, function () {
                skipSubscriber === null || skipSubscriber === void 0 ? void 0 : skipSubscriber.unsubscribe();
                taking = true;
            }, undefined, noop);
            from(notifier).subscribe(skipSubscriber);
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return taking && subscriber.next(value); }));
        });
    }

    function skipWhile(predicate) {
        return operate(function (source, subscriber) {
            var taking = false;
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return (taking || (taking = !predicate(value, index++))) && subscriber.next(value); }));
        });
    }

    function startWith() {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        var scheduler = values[values.length - 1];
        if (isScheduler(scheduler)) {
            values.pop();
            return function (source) { return concat(values, source, scheduler); };
        }
        else {
            return function (source) { return concat(values, source); };
        }
    }

    function subscribeOn(scheduler, delay) {
        if (delay === void 0) { delay = 0; }
        return operate(function (source, subscriber) {
            subscriber.add(scheduler.schedule(function () { return source.subscribe(subscriber); }, delay));
        });
    }

    function switchMap(project, resultSelector) {
        return operate(function (source, subscriber) {
            var innerSubscriber = null;
            var index = 0;
            var isComplete = false;
            var checkComplete = function () { return isComplete && !innerSubscriber && subscriber.complete(); };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                innerSubscriber === null || innerSubscriber === void 0 ? void 0 : innerSubscriber.unsubscribe();
                var innerIndex = 0;
                var outerIndex = index++;
                from(project(value, outerIndex)).subscribe((innerSubscriber = new OperatorSubscriber(subscriber, function (innerValue) { return subscriber.next(resultSelector ? resultSelector(value, innerValue, outerIndex, innerIndex++) : innerValue); }, undefined, function () {
                    innerSubscriber = null;
                    checkComplete();
                })));
            }, undefined, function () {
                isComplete = true;
                checkComplete();
            }));
        });
    }

    function switchAll() {
        return switchMap(identity);
    }

    function switchMapTo(innerObservable, resultSelector) {
        return resultSelector ? switchMap(function () { return innerObservable; }, resultSelector) : switchMap(function () { return innerObservable; });
    }

    function takeUntil(notifier) {
        return operate(function (source, subscriber) {
            from(notifier).subscribe(new OperatorSubscriber(subscriber, function () { return subscriber.complete(); }, undefined, noop));
            !subscriber.closed && source.subscribe(subscriber);
        });
    }

    function takeWhile(predicate, inclusive) {
        if (inclusive === void 0) { inclusive = false; }
        return operate(function (source, subscriber) {
            var index = 0;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var result = predicate(value, index++);
                (result || inclusive) && subscriber.next(value);
                !result && subscriber.complete();
            }));
        });
    }

    function tap(observerOrNext, error, complete) {
        var tapObserver = isFunction(observerOrNext) || error || complete ? { next: observerOrNext, error: error, complete: complete } : observerOrNext;
        return tapObserver
            ? operate(function (source, subscriber) {
                source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                    var _a;
                    (_a = tapObserver.next) === null || _a === void 0 ? void 0 : _a.call(tapObserver, value);
                    subscriber.next(value);
                }, function (err) {
                    var _a;
                    (_a = tapObserver.error) === null || _a === void 0 ? void 0 : _a.call(tapObserver, err);
                    subscriber.error(err);
                }, function () {
                    var _a;
                    (_a = tapObserver.complete) === null || _a === void 0 ? void 0 : _a.call(tapObserver);
                    subscriber.complete();
                }));
            })
            :
                identity;
    }

    var defaultThrottleConfig = {
        leading: true,
        trailing: false,
    };
    function throttle(durationSelector, _a) {
        var _b = _a === void 0 ? defaultThrottleConfig : _a, leading = _b.leading, trailing = _b.trailing;
        return operate(function (source, subscriber) {
            var hasValue = false;
            var sendValue = null;
            var throttled = null;
            var throttlingDone = function () {
                throttled === null || throttled === void 0 ? void 0 : throttled.unsubscribe();
                throttled = null;
                trailing && send();
            };
            var throttle = function (value) {
                return (throttled = from(durationSelector(value)).subscribe(new OperatorSubscriber(subscriber, throttlingDone, undefined, throttlingDone)));
            };
            var send = function () {
                if (hasValue) {
                    subscriber.next(sendValue);
                    throttle(sendValue);
                }
                hasValue = false;
                sendValue = null;
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                hasValue = true;
                sendValue = value;
                !throttled && (leading ? send() : throttle(value));
            }));
        });
    }

    function throttleTime(duration, scheduler, _a) {
        if (scheduler === void 0) { scheduler = asyncScheduler; }
        var _b = _a === void 0 ? defaultThrottleConfig : _a, _c = _b.leading, leading = _c === void 0 ? false : _c, _d = _b.trailing, trailing = _d === void 0 ? false : _d;
        return operate(function (source, subscriber) {
            var hasTrailingValue = false;
            var trailingValue = null;
            var throttleSubs = null;
            var isComplete = false;
            var throttleJob = function () {
                throttleSubs = null;
                if (trailing && hasTrailingValue) {
                    hasTrailingValue = false;
                    emit(trailingValue);
                    trailingValue = null;
                }
                if (isComplete) {
                    subscriber.complete();
                }
            };
            var startThrottle = function () { return subscriber.add((throttleSubs = scheduler.schedule(throttleJob, duration))); };
            var setTrailing = function (value) {
                if (trailing) {
                    hasTrailingValue = true;
                    trailingValue = value;
                }
            };
            var emit = function (value) {
                subscriber.next(value);
                !isComplete && startThrottle();
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                if (throttleSubs) {
                    setTrailing(value);
                }
                else {
                    if (leading) {
                        emit(value);
                    }
                    else {
                        setTrailing(value);
                        startThrottle();
                    }
                }
            }, undefined, function () {
                isComplete = true;
                (!trailing || !throttleSubs || !hasTrailingValue) && subscriber.complete();
            }));
        });
    }

    function timeInterval(scheduler) {
        if (scheduler === void 0) { scheduler = async; }
        return function (source) { return defer(function () {
            return source.pipe(scan(function (_a, value) {
                var current = _a.current;
                return ({ value: value, current: scheduler.now(), last: current });
            }, { current: scheduler.now(), value: undefined, last: undefined }), map(function (_a) {
                var current = _a.current, last = _a.last, value = _a.value;
                return new TimeInterval(value, current - last);
            }));
        }); };
    }
    var TimeInterval = (function () {
        function TimeInterval(value, interval) {
            this.value = value;
            this.interval = interval;
        }
        return TimeInterval;
    }());

    function timeoutWith(due, withObservable, scheduler) {
        var first;
        var each = undefined;
        var _with;
        scheduler = scheduler !== null && scheduler !== void 0 ? scheduler : async;
        if (isValidDate(due)) {
            first = due;
        }
        else if (typeof due === 'number') {
            each = due;
        }
        if (withObservable) {
            _with = function () { return withObservable; };
        }
        else {
            throw new TypeError('No observable provided to switch to');
        }
        if (first == null && each == null) {
            throw new TypeError('No timeout provided.');
        }
        return timeout({
            first: first,
            each: each,
            scheduler: scheduler,
            with: _with,
        });
    }

    function timestamp(timestampProvider) {
        if (timestampProvider === void 0) { timestampProvider = dateTimestampProvider; }
        return map(function (value) { return ({ value: value, timestamp: timestampProvider.now() }); });
    }

    function window(windowBoundaries) {
        return operate(function (source, subscriber) {
            var windowSubject = new Subject();
            subscriber.next(windowSubject.asObservable());
            var windowSubscribe = function (source, next) {
                return source.subscribe(new OperatorSubscriber(subscriber, next, function (err) {
                    windowSubject.error(err);
                    subscriber.error(err);
                }, function () {
                    windowSubject.complete();
                    subscriber.complete();
                }));
            };
            windowSubscribe(source, function (value) { return windowSubject.next(value); });
            windowSubscribe(windowBoundaries, function () {
                windowSubject.complete();
                subscriber.next((windowSubject = new Subject()));
            });
            return function () {
                windowSubject.unsubscribe();
                windowSubject = null;
            };
        });
    }

    function windowCount(windowSize, startWindowEvery) {
        if (startWindowEvery === void 0) { startWindowEvery = 0; }
        var startEvery = startWindowEvery > 0 ? startWindowEvery : windowSize;
        return operate(function (source, subscriber) {
            var windows = [new Subject()];
            var count = 0;
            subscriber.next(windows[0].asObservable());
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                for (var _i = 0, windows_1 = windows; _i < windows_1.length; _i++) {
                    var window_1 = windows_1[_i];
                    window_1.next(value);
                }
                var c = count - windowSize + 1;
                if (c >= 0 && c % startEvery === 0) {
                    windows.shift().complete();
                }
                if (++count % startEvery === 0) {
                    var window_2 = new Subject();
                    windows.push(window_2);
                    subscriber.next(window_2.asObservable());
                }
            }, function (err) {
                while (windows.length > 0) {
                    windows.shift().error(err);
                }
                subscriber.error(err);
            }, function () {
                while (windows.length > 0) {
                    windows.shift().complete();
                }
                subscriber.complete();
            }, function () {
                windows = null;
            }));
        });
    }

    function windowTime(windowTimeSpan) {
        var _a;
        var otherArgs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            otherArgs[_i - 1] = arguments[_i];
        }
        var scheduler = isScheduler(otherArgs[otherArgs.length - 1]) ? otherArgs.pop() : asyncScheduler;
        var windowCreationInterval = (_a = otherArgs[0]) !== null && _a !== void 0 ? _a : null;
        var maxWindowSize = otherArgs[1] || Infinity;
        return operate(function (source, subscriber) {
            var windowRecords = [];
            var restartOnClose = false;
            var closeWindow = function (record) {
                var window = record.window, subs = record.subs;
                window.complete();
                subs.unsubscribe();
                arrRemove(windowRecords, record);
                restartOnClose && startWindow();
            };
            var startWindow = function () {
                if (windowRecords) {
                    var subs = new Subscription();
                    subscriber.add(subs);
                    var window_1 = new Subject();
                    var record_1 = {
                        window: window_1,
                        subs: subs,
                        seen: 0,
                    };
                    windowRecords.push(record_1);
                    subscriber.next(window_1.asObservable());
                    subs.add(scheduler.schedule(function () { return closeWindow(record_1); }, windowTimeSpan));
                }
            };
            windowCreationInterval !== null && windowCreationInterval >= 0
                ?
                    subscriber.add(scheduler.schedule(function () {
                        startWindow();
                        !this.closed && subscriber.add(this.schedule(null, windowCreationInterval));
                    }, windowCreationInterval))
                : (restartOnClose = true);
            startWindow();
            var loop = function (cb) { return windowRecords.slice().forEach(cb); };
            var terminate = function (cb) {
                loop(function (_a) {
                    var window = _a.window;
                    return cb(window);
                });
                cb(subscriber);
                subscriber.unsubscribe();
            };
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                loop(function (record) {
                    record.window.next(value);
                    maxWindowSize <= ++record.seen && closeWindow(record);
                });
            }, function (err) { return terminate(function (consumer) { return consumer.error(err); }); }, function () { return terminate(function (consumer) { return consumer.complete(); }); }));
            return function () {
                windowRecords = null;
            };
        });
    }

    function windowToggle(openings, closingSelector) {
        return operate(function (source, subscriber) {
            var windows = [];
            var handleError = function (err) {
                while (0 < windows.length) {
                    windows.shift().error(err);
                }
                subscriber.error(err);
            };
            var openNotifier;
            try {
                openNotifier = from(openings);
            }
            catch (err) {
                subscriber.error(err);
                return;
            }
            openNotifier.subscribe(new OperatorSubscriber(subscriber, function (openValue) {
                var window = new Subject();
                windows.push(window);
                var closingSubscription = new Subscription();
                var closeWindow = function () {
                    arrRemove(windows, window);
                    window.complete();
                    closingSubscription.unsubscribe();
                };
                var closingNotifier;
                try {
                    closingNotifier = from(closingSelector(openValue));
                }
                catch (err) {
                    handleError(err);
                    return;
                }
                subscriber.next(window.asObservable());
                closingSubscription.add(closingNotifier.subscribe(new OperatorSubscriber(subscriber, closeWindow, handleError, closeWindow)));
            }, undefined, noop));
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                var windowsCopy = windows.slice();
                for (var _i = 0, windowsCopy_1 = windowsCopy; _i < windowsCopy_1.length; _i++) {
                    var window_1 = windowsCopy_1[_i];
                    window_1.next(value);
                }
            }, handleError, function () {
                while (0 < windows.length) {
                    windows.shift().complete();
                }
                subscriber.complete();
            }, function () {
                while (0 < windows.length) {
                    windows.shift().unsubscribe();
                }
            }));
        });
    }

    function windowWhen(closingSelector) {
        return operate(function (source, subscriber) {
            var window;
            var closingSubscriber;
            var handleError = function (err) {
                window.error(err);
                subscriber.error(err);
            };
            var openWindow = function () {
                closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
                window === null || window === void 0 ? void 0 : window.complete();
                window = new Subject();
                subscriber.next(window.asObservable());
                var closingNotifier;
                try {
                    closingNotifier = from(closingSelector());
                }
                catch (err) {
                    handleError(err);
                    return;
                }
                closingNotifier.subscribe((closingSubscriber = new OperatorSubscriber(subscriber, openWindow, handleError, openWindow)));
            };
            openWindow();
            source.subscribe(new OperatorSubscriber(subscriber, function (value) { return window.next(value); }, handleError, function () {
                window.complete();
                subscriber.complete();
            }, function () {
                closingSubscriber === null || closingSubscriber === void 0 ? void 0 : closingSubscriber.unsubscribe();
                window = null;
            }));
        });
    }

    function withLatestFrom() {
        var inputs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            inputs[_i] = arguments[_i];
        }
        var project;
        if (typeof inputs[inputs.length - 1] === 'function') {
            project = inputs.pop();
        }
        return operate(function (source, subscriber) {
            var len = inputs.length;
            var otherValues = new Array(len);
            var hasValue = inputs.map(function () { return false; });
            var ready = false;
            source.subscribe(new OperatorSubscriber(subscriber, function (value) {
                if (ready) {
                    var values = __spreadArrays([value], otherValues);
                    subscriber.next(project ? project.apply(void 0, values) : values);
                }
            }));
            var _loop_1 = function (i) {
                var input = inputs[i];
                var otherSource = void 0;
                try {
                    otherSource = from(input);
                }
                catch (err) {
                    subscriber.error(err);
                    return { value: void 0 };
                }
                otherSource.subscribe(new OperatorSubscriber(subscriber, function (value) {
                    otherValues[i] = value;
                    if (!ready && !hasValue[i]) {
                        hasValue[i] = true;
                        (ready = hasValue.every(identity)) && (hasValue = null);
                    }
                }, undefined, noop));
            };
            for (var i = 0; i < len; i++) {
                var state_1 = _loop_1(i);
                if (typeof state_1 === "object")
                    return state_1.value;
            }
        });
    }

    function zip$1() {
        var sources = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sources[_i] = arguments[_i];
        }
        return operate(function (source, subscriber) {
            zip.apply(void 0, __spreadArrays([source], sources)).subscribe(subscriber);
        });
    }
    function zipWith() {
        var otherInputs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            otherInputs[_i] = arguments[_i];
        }
        return zip$1.apply(void 0, otherInputs);
    }

    function zipAll(project) {
        return operate(function (source, subscriber) {
            var sources = [];
            subscriber.add(source.subscribe({
                next: function (source) { return sources.push(source); },
                error: function (err) { return subscriber.error(err); },
                complete: function () {
                    if (sources.length > 0) {
                        var args = project ? __spreadArrays(sources, [project]) : sources;
                        subscriber.add(zip.apply(void 0, args).subscribe(subscriber));
                    }
                    else {
                        subscriber.complete();
                    }
                },
            }));
        });
    }



    var _operators = /*#__PURE__*/Object.freeze({
        audit: audit,
        auditTime: auditTime,
        buffer: buffer,
        bufferCount: bufferCount,
        bufferTime: bufferTime,
        bufferToggle: bufferToggle,
        bufferWhen: bufferWhen,
        catchError: catchError,
        combineAll: combineAll,
        combineLatest: combineLatest$1,
        combineLatestWith: combineLatestWith,
        concatAll: concatAll,
        concatMap: concatMap,
        concatMapTo: concatMapTo,
        concat: concat$1,
        concatWith: concatWith,
        count: count,
        debounce: debounce,
        debounceTime: debounceTime,
        defaultIfEmpty: defaultIfEmpty,
        delay: delay,
        delayWhen: delayWhen,
        dematerialize: dematerialize,
        distinct: distinct,
        distinctUntilChanged: distinctUntilChanged,
        distinctUntilKeyChanged: distinctUntilKeyChanged,
        elementAt: elementAt,
        endWith: endWith,
        every: every,
        exhaust: exhaust,
        exhaustMap: exhaustMap,
        expand: expand,
        filter: filter,
        finalize: finalize,
        find: find,
        findIndex: findIndex,
        first: first,
        groupBy: groupBy,
        ignoreElements: ignoreElements,
        isEmpty: isEmpty,
        last: last,
        map: map,
        mapTo: mapTo,
        materialize: materialize,
        max: max,
        mergeWith: mergeWith,
        merge: merge$1,
        mergeAll: mergeAll,
        mergeMap: mergeMap,
        flatMap: flatMap,
        mergeMapTo: mergeMapTo,
        mergeScan: mergeScan,
        min: min,
        multicast: multicast,
        observeOn: observeOn,
        onErrorResumeNext: onErrorResumeNext,
        pairwise: pairwise,
        partition: partition$1,
        pluck: pluck,
        publish: publish,
        publishBehavior: publishBehavior,
        publishLast: publishLast,
        publishReplay: publishReplay,
        race: race$1,
        raceWith: raceWith,
        reduce: reduce,
        repeat: repeat,
        repeatWhen: repeatWhen,
        retry: retry,
        retryWhen: retryWhen,
        refCount: refCount,
        sample: sample,
        sampleTime: sampleTime,
        scan: scan,
        sequenceEqual: sequenceEqual,
        share: share,
        shareReplay: shareReplay,
        single: single,
        skip: skip,
        skipLast: skipLast,
        skipUntil: skipUntil,
        skipWhile: skipWhile,
        startWith: startWith,
        subscribeOn: subscribeOn,
        switchAll: switchAll,
        switchMap: switchMap,
        switchMapTo: switchMapTo,
        take: take,
        takeLast: takeLast,
        takeUntil: takeUntil,
        takeWhile: takeWhile,
        tap: tap,
        throttle: throttle,
        throttleTime: throttleTime,
        throwIfEmpty: throwIfEmpty,
        timeInterval: timeInterval,
        timeout: timeout,
        timeoutWith: timeoutWith,
        timestamp: timestamp,
        toArray: toArray,
        window: window,
        windowCount: windowCount,
        windowTime: windowTime,
        windowToggle: windowToggle,
        windowWhen: windowWhen,
        withLatestFrom: withLatestFrom,
        zip: zip$1,
        zipWith: zipWith,
        zipAll: zipAll
    });

    var SubscriptionLog = (function () {
        function SubscriptionLog(subscribedFrame, unsubscribedFrame) {
            if (unsubscribedFrame === void 0) { unsubscribedFrame = Infinity; }
            this.subscribedFrame = subscribedFrame;
            this.unsubscribedFrame = unsubscribedFrame;
        }
        return SubscriptionLog;
    }());

    var SubscriptionLoggable = (function () {
        function SubscriptionLoggable() {
            this.subscriptions = [];
        }
        SubscriptionLoggable.prototype.logSubscribedFrame = function () {
            this.subscriptions.push(new SubscriptionLog(this.scheduler.now()));
            return this.subscriptions.length - 1;
        };
        SubscriptionLoggable.prototype.logUnsubscribedFrame = function (index) {
            var subscriptionLogs = this.subscriptions;
            var oldSubscriptionLog = subscriptionLogs[index];
            subscriptionLogs[index] = new SubscriptionLog(oldSubscriptionLog.subscribedFrame, this.scheduler.now());
        };
        return SubscriptionLoggable;
    }());

    function applyMixins(derivedCtor, baseCtors) {
        for (var i = 0, len = baseCtors.length; i < len; i++) {
            var baseCtor = baseCtors[i];
            var propertyKeys = Object.getOwnPropertyNames(baseCtor.prototype);
            for (var j = 0, len2 = propertyKeys.length; j < len2; j++) {
                var name_1 = propertyKeys[j];
                derivedCtor.prototype[name_1] = baseCtor.prototype[name_1];
            }
        }
    }

    var ColdObservable = (function (_super) {
        __extends(ColdObservable, _super);
        function ColdObservable(messages, scheduler) {
            var _this = _super.call(this, function (subscriber) {
                var observable = this;
                var index = observable.logSubscribedFrame();
                var subscription = new Subscription();
                subscription.add(new Subscription(function () {
                    observable.logUnsubscribedFrame(index);
                }));
                observable.scheduleMessages(subscriber);
                return subscription;
            }) || this;
            _this.messages = messages;
            _this.subscriptions = [];
            _this.scheduler = scheduler;
            return _this;
        }
        ColdObservable.prototype.scheduleMessages = function (subscriber) {
            var messagesLength = this.messages.length;
            for (var i = 0; i < messagesLength; i++) {
                var message = this.messages[i];
                subscriber.add(this.scheduler.schedule(function (state) {
                    var _a = state, message = _a.message, subscriber = _a.subscriber;
                    observeNotification(message.notification, subscriber);
                }, message.frame, { message: message, subscriber: subscriber }));
            }
        };
        return ColdObservable;
    }(Observable));
    applyMixins(ColdObservable, [SubscriptionLoggable]);

    var HotObservable = (function (_super) {
        __extends(HotObservable, _super);
        function HotObservable(messages, scheduler) {
            var _this = _super.call(this) || this;
            _this.messages = messages;
            _this.subscriptions = [];
            _this.scheduler = scheduler;
            return _this;
        }
        HotObservable.prototype._subscribe = function (subscriber) {
            var subject = this;
            var index = subject.logSubscribedFrame();
            var subscription = new Subscription();
            subscription.add(new Subscription(function () {
                subject.logUnsubscribedFrame(index);
            }));
            subscription.add(_super.prototype._subscribe.call(this, subscriber));
            return subscription;
        };
        HotObservable.prototype.setup = function () {
            var subject = this;
            var messagesLength = subject.messages.length;
            for (var i = 0; i < messagesLength; i++) {
                (function () {
                    var message = subject.messages[i];
                    subject.scheduler.schedule(function () {
                        observeNotification(message.notification, subject);
                    }, message.frame);
                })();
            }
        };
        return HotObservable;
    }(Subject));
    applyMixins(HotObservable, [SubscriptionLoggable]);

    var defaultMaxFrame = 750;
    var TestScheduler = (function (_super) {
        __extends(TestScheduler, _super);
        function TestScheduler(assertDeepEqual) {
            var _this = _super.call(this, VirtualAction, defaultMaxFrame) || this;
            _this.assertDeepEqual = assertDeepEqual;
            _this.hotObservables = [];
            _this.coldObservables = [];
            _this.flushTests = [];
            _this.runMode = false;
            return _this;
        }
        TestScheduler.prototype.createTime = function (marbles) {
            var indexOf = marbles.trim().indexOf('|');
            if (indexOf === -1) {
                throw new Error('marble diagram for time should have a completion marker "|"');
            }
            return indexOf * TestScheduler.frameTimeFactor;
        };
        TestScheduler.prototype.createColdObservable = function (marbles, values, error) {
            if (marbles.indexOf('^') !== -1) {
                throw new Error('cold observable cannot have subscription offset "^"');
            }
            if (marbles.indexOf('!') !== -1) {
                throw new Error('cold observable cannot have unsubscription marker "!"');
            }
            var messages = TestScheduler.parseMarbles(marbles, values, error, undefined, this.runMode);
            var cold = new ColdObservable(messages, this);
            this.coldObservables.push(cold);
            return cold;
        };
        TestScheduler.prototype.createHotObservable = function (marbles, values, error) {
            if (marbles.indexOf('!') !== -1) {
                throw new Error('hot observable cannot have unsubscription marker "!"');
            }
            var messages = TestScheduler.parseMarbles(marbles, values, error, undefined, this.runMode);
            var subject = new HotObservable(messages, this);
            this.hotObservables.push(subject);
            return subject;
        };
        TestScheduler.prototype.materializeInnerObservable = function (observable, outerFrame) {
            var _this = this;
            var messages = [];
            observable.subscribe(function (value) {
                messages.push({ frame: _this.frame - outerFrame, notification: nextNotification(value) });
            }, function (error) {
                messages.push({ frame: _this.frame - outerFrame, notification: errorNotification(error) });
            }, function () {
                messages.push({ frame: _this.frame - outerFrame, notification: COMPLETE_NOTIFICATION });
            });
            return messages;
        };
        TestScheduler.prototype.expectObservable = function (observable, subscriptionMarbles) {
            var _this = this;
            if (subscriptionMarbles === void 0) { subscriptionMarbles = null; }
            var actual = [];
            var flushTest = { actual: actual, ready: false };
            var subscriptionParsed = TestScheduler.parseMarblesAsSubscriptions(subscriptionMarbles, this.runMode);
            var subscriptionFrame = subscriptionParsed.subscribedFrame === Infinity ?
                0 : subscriptionParsed.subscribedFrame;
            var unsubscriptionFrame = subscriptionParsed.unsubscribedFrame;
            var subscription;
            this.schedule(function () {
                subscription = observable.subscribe(function (x) {
                    var value = x;
                    if (x instanceof Observable) {
                        value = _this.materializeInnerObservable(value, _this.frame);
                    }
                    actual.push({ frame: _this.frame, notification: nextNotification(value) });
                }, function (error) {
                    actual.push({ frame: _this.frame, notification: errorNotification(error) });
                }, function () {
                    actual.push({ frame: _this.frame, notification: COMPLETE_NOTIFICATION });
                });
            }, subscriptionFrame);
            if (unsubscriptionFrame !== Infinity) {
                this.schedule(function () { return subscription.unsubscribe(); }, unsubscriptionFrame);
            }
            this.flushTests.push(flushTest);
            var runMode = this.runMode;
            return {
                toBe: function (marbles, values, errorValue) {
                    flushTest.ready = true;
                    flushTest.expected = TestScheduler.parseMarbles(marbles, values, errorValue, true, runMode);
                }
            };
        };
        TestScheduler.prototype.expectSubscriptions = function (actualSubscriptionLogs) {
            var flushTest = { actual: actualSubscriptionLogs, ready: false };
            this.flushTests.push(flushTest);
            var runMode = this.runMode;
            return {
                toBe: function (marbles) {
                    var marblesArray = (typeof marbles === 'string') ? [marbles] : marbles;
                    flushTest.ready = true;
                    flushTest.expected = marblesArray.map(function (marbles) {
                        return TestScheduler.parseMarblesAsSubscriptions(marbles, runMode);
                    }).filter(function (marbles) { return marbles.subscribedFrame !== Infinity; });
                }
            };
        };
        TestScheduler.prototype.flush = function () {
            var _this = this;
            var hotObservables = this.hotObservables;
            while (hotObservables.length > 0) {
                hotObservables.shift().setup();
            }
            _super.prototype.flush.call(this);
            this.flushTests = this.flushTests.filter(function (test) {
                if (test.ready) {
                    _this.assertDeepEqual(test.actual, test.expected);
                    return false;
                }
                return true;
            });
        };
        TestScheduler.parseMarblesAsSubscriptions = function (marbles, runMode) {
            var _this = this;
            if (runMode === void 0) { runMode = false; }
            if (typeof marbles !== 'string') {
                return new SubscriptionLog(Infinity);
            }
            var len = marbles.length;
            var groupStart = -1;
            var subscriptionFrame = Infinity;
            var unsubscriptionFrame = Infinity;
            var frame = 0;
            var _loop_1 = function (i) {
                var nextFrame = frame;
                var advanceFrameBy = function (count) {
                    nextFrame += count * _this.frameTimeFactor;
                };
                var c = marbles[i];
                switch (c) {
                    case ' ':
                        if (!runMode) {
                            advanceFrameBy(1);
                        }
                        break;
                    case '-':
                        advanceFrameBy(1);
                        break;
                    case '(':
                        groupStart = frame;
                        advanceFrameBy(1);
                        break;
                    case ')':
                        groupStart = -1;
                        advanceFrameBy(1);
                        break;
                    case '^':
                        if (subscriptionFrame !== Infinity) {
                            throw new Error('found a second subscription point \'^\' in a ' +
                                'subscription marble diagram. There can only be one.');
                        }
                        subscriptionFrame = groupStart > -1 ? groupStart : frame;
                        advanceFrameBy(1);
                        break;
                    case '!':
                        if (unsubscriptionFrame !== Infinity) {
                            throw new Error('found a second subscription point \'^\' in a ' +
                                'subscription marble diagram. There can only be one.');
                        }
                        unsubscriptionFrame = groupStart > -1 ? groupStart : frame;
                        break;
                    default:
                        if (runMode && c.match(/^[0-9]$/)) {
                            if (i === 0 || marbles[i - 1] === ' ') {
                                var buffer = marbles.slice(i);
                                var match = buffer.match(/^([0-9]+(?:\.[0-9]+)?)(ms|s|m) /);
                                if (match) {
                                    i += match[0].length - 1;
                                    var duration = parseFloat(match[1]);
                                    var unit = match[2];
                                    var durationInMs = void 0;
                                    switch (unit) {
                                        case 'ms':
                                            durationInMs = duration;
                                            break;
                                        case 's':
                                            durationInMs = duration * 1000;
                                            break;
                                        case 'm':
                                            durationInMs = duration * 1000 * 60;
                                            break;
                                        default:
                                            break;
                                    }
                                    advanceFrameBy(durationInMs / this_1.frameTimeFactor);
                                    break;
                                }
                            }
                        }
                        throw new Error('there can only be \'^\' and \'!\' markers in a ' +
                            'subscription marble diagram. Found instead \'' + c + '\'.');
                }
                frame = nextFrame;
                out_i_1 = i;
            };
            var this_1 = this, out_i_1;
            for (var i = 0; i < len; i++) {
                _loop_1(i);
                i = out_i_1;
            }
            if (unsubscriptionFrame < 0) {
                return new SubscriptionLog(subscriptionFrame);
            }
            else {
                return new SubscriptionLog(subscriptionFrame, unsubscriptionFrame);
            }
        };
        TestScheduler.parseMarbles = function (marbles, values, errorValue, materializeInnerObservables, runMode) {
            var _this = this;
            if (materializeInnerObservables === void 0) { materializeInnerObservables = false; }
            if (runMode === void 0) { runMode = false; }
            if (marbles.indexOf('!') !== -1) {
                throw new Error('conventional marble diagrams cannot have the ' +
                    'unsubscription marker "!"');
            }
            var len = marbles.length;
            var testMessages = [];
            var subIndex = runMode ? marbles.replace(/^[ ]+/, '').indexOf('^') : marbles.indexOf('^');
            var frame = subIndex === -1 ? 0 : (subIndex * -this.frameTimeFactor);
            var getValue = typeof values !== 'object' ?
                function (x) { return x; } :
                function (x) {
                    if (materializeInnerObservables && values[x] instanceof ColdObservable) {
                        return values[x].messages;
                    }
                    return values[x];
                };
            var groupStart = -1;
            var _loop_2 = function (i) {
                var nextFrame = frame;
                var advanceFrameBy = function (count) {
                    nextFrame += count * _this.frameTimeFactor;
                };
                var notification = void 0;
                var c = marbles[i];
                switch (c) {
                    case ' ':
                        if (!runMode) {
                            advanceFrameBy(1);
                        }
                        break;
                    case '-':
                        advanceFrameBy(1);
                        break;
                    case '(':
                        groupStart = frame;
                        advanceFrameBy(1);
                        break;
                    case ')':
                        groupStart = -1;
                        advanceFrameBy(1);
                        break;
                    case '|':
                        notification = COMPLETE_NOTIFICATION;
                        advanceFrameBy(1);
                        break;
                    case '^':
                        advanceFrameBy(1);
                        break;
                    case '#':
                        notification = errorNotification(errorValue || 'error');
                        advanceFrameBy(1);
                        break;
                    default:
                        if (runMode && c.match(/^[0-9]$/)) {
                            if (i === 0 || marbles[i - 1] === ' ') {
                                var buffer = marbles.slice(i);
                                var match = buffer.match(/^([0-9]+(?:\.[0-9]+)?)(ms|s|m) /);
                                if (match) {
                                    i += match[0].length - 1;
                                    var duration = parseFloat(match[1]);
                                    var unit = match[2];
                                    var durationInMs = void 0;
                                    switch (unit) {
                                        case 'ms':
                                            durationInMs = duration;
                                            break;
                                        case 's':
                                            durationInMs = duration * 1000;
                                            break;
                                        case 'm':
                                            durationInMs = duration * 1000 * 60;
                                            break;
                                        default:
                                            break;
                                    }
                                    advanceFrameBy(durationInMs / this_2.frameTimeFactor);
                                    break;
                                }
                            }
                        }
                        notification = nextNotification(getValue(c));
                        advanceFrameBy(1);
                        break;
                }
                if (notification) {
                    testMessages.push({ frame: groupStart > -1 ? groupStart : frame, notification: notification });
                }
                frame = nextFrame;
                out_i_2 = i;
            };
            var this_2 = this, out_i_2;
            for (var i = 0; i < len; i++) {
                _loop_2(i);
                i = out_i_2;
            }
            return testMessages;
        };
        TestScheduler.prototype.createAnimator = function () {
            var _this = this;
            if (!this.runMode) {
                throw new Error('animate() must only be used in run mode');
            }
            var lastHandle = 0;
            var map;
            var delegate = {
                requestAnimationFrame: function (callback) {
                    if (!map) {
                        throw new Error("animate() was not called within run()");
                    }
                    var handle = ++lastHandle;
                    map.set(handle, callback);
                    return handle;
                },
                cancelAnimationFrame: function (handle) {
                    if (!map) {
                        throw new Error("animate() was not called within run()");
                    }
                    map.delete(handle);
                }
            };
            var animate = function (marbles) {
                if (map) {
                    throw new Error('animate() must not be called more than once within run()');
                }
                if (/[|#]/.test(marbles)) {
                    throw new Error('animate() must not complete or error');
                }
                map = new Map();
                var messages = TestScheduler.parseMarbles(marbles, undefined, undefined, undefined, true);
                for (var _i = 0, messages_1 = messages; _i < messages_1.length; _i++) {
                    var message = messages_1[_i];
                    _this.schedule(function () {
                        var now = _this.now();
                        var callbacks = Array.from(map.values());
                        map.clear();
                        for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                            var callback = callbacks_1[_i];
                            callback(now);
                        }
                    }, message.frame);
                }
            };
            return { animate: animate, delegate: delegate };
        };
        TestScheduler.prototype.createDelegates = function () {
            var _this = this;
            var lastHandle = 0;
            var map = new Map();
            var run = function () {
                var now = _this.now();
                var values = Array.from(map.values());
                var due = values.filter(function (_a) {
                    var due = _a.due;
                    return due <= now;
                });
                var immediates = due.filter(function (_a) {
                    var type = _a.type;
                    return type === 'immediate';
                });
                if (immediates.length > 0) {
                    var _a = immediates[0], handle = _a.handle, handler = _a.handler;
                    map.delete(handle);
                    handler();
                    return;
                }
                var intervals = due.filter(function (_a) {
                    var type = _a.type;
                    return type === 'interval';
                });
                if (intervals.length > 0) {
                    var interval_1 = intervals[0];
                    var duration = interval_1.duration, handler = interval_1.handler;
                    interval_1.due = now + duration;
                    interval_1.subscription = _this.schedule(run, duration);
                    handler();
                    return;
                }
                throw new Error('Expected a due immediate or interval');
            };
            var immediate = {
                setImmediate: function (handler) {
                    var handle = ++lastHandle;
                    map.set(handle, {
                        due: _this.now(),
                        duration: 0,
                        handle: handle,
                        handler: handler,
                        subscription: _this.schedule(run, 0),
                        type: 'immediate',
                    });
                    return handle;
                },
                clearImmediate: function (handle) {
                    var value = map.get(handle);
                    if (value) {
                        value.subscription.unsubscribe();
                        map.delete(handle);
                    }
                }
            };
            var interval = {
                setInterval: function (handler, duration) {
                    if (duration === void 0) { duration = 0; }
                    var handle = ++lastHandle;
                    map.set(handle, {
                        due: _this.now() + duration,
                        duration: duration,
                        handle: handle,
                        handler: handler,
                        subscription: _this.schedule(run, duration),
                        type: 'interval',
                    });
                    return handle;
                },
                clearInterval: function (handle) {
                    var value = map.get(handle);
                    if (value) {
                        value.subscription.unsubscribe();
                        map.delete(handle);
                    }
                }
            };
            return { immediate: immediate, interval: interval };
        };
        TestScheduler.prototype.run = function (callback) {
            var prevFrameTimeFactor = TestScheduler.frameTimeFactor;
            var prevMaxFrames = this.maxFrames;
            TestScheduler.frameTimeFactor = 1;
            this.maxFrames = Infinity;
            this.runMode = true;
            var animator = this.createAnimator();
            var delegates = this.createDelegates();
            animationFrameProvider.delegate = animator.delegate;
            dateTimestampProvider.delegate = this;
            immediateProvider.delegate = delegates.immediate;
            intervalProvider.delegate = delegates.interval;
            performanceTimestampProvider.delegate = this;
            var helpers = {
                cold: this.createColdObservable.bind(this),
                hot: this.createHotObservable.bind(this),
                flush: this.flush.bind(this),
                time: this.createTime.bind(this),
                expectObservable: this.expectObservable.bind(this),
                expectSubscriptions: this.expectSubscriptions.bind(this),
                animate: animator.animate,
            };
            try {
                var ret = callback(helpers);
                this.flush();
                return ret;
            }
            finally {
                TestScheduler.frameTimeFactor = prevFrameTimeFactor;
                this.maxFrames = prevMaxFrames;
                this.runMode = false;
                animationFrameProvider.delegate = undefined;
                dateTimestampProvider.delegate = undefined;
                immediateProvider.delegate = undefined;
                intervalProvider.delegate = undefined;
                performanceTimestampProvider.delegate = undefined;
            }
        };
        TestScheduler.frameTimeFactor = 10;
        return TestScheduler;
    }(VirtualTimeScheduler));



    var _testing = /*#__PURE__*/Object.freeze({
        TestScheduler: TestScheduler
    });

    function getXHRResponse(xhr) {
        switch (xhr.responseType) {
            case 'json': {
                if ('response' in xhr) {
                    return xhr.response;
                }
                else {
                    var ieXHR = xhr;
                    return JSON.parse(ieXHR.responseText);
                }
            }
            case 'document':
                return xhr.responseXML;
            case 'text':
            default: {
                if ('response' in xhr) {
                    return xhr.response;
                }
                else {
                    var ieXHR = xhr;
                    return ieXHR.responseText;
                }
            }
        }
    }

    var AjaxResponse = (function () {
        function AjaxResponse(originalEvent, xhr, request) {
            this.originalEvent = originalEvent;
            this.xhr = xhr;
            this.request = request;
            this.status = xhr.status;
            this.responseType = xhr.responseType;
            this.response = getXHRResponse(xhr);
        }
        return AjaxResponse;
    }());

    var AjaxError = createErrorClass(function (_super) {
        return function AjaxError(message, xhr, request) {
            this.message = message;
            this.name = 'AjaxError';
            this.xhr = xhr;
            this.request = request;
            this.status = xhr.status;
            this.responseType = xhr.responseType;
            var response;
            try {
                response = getXHRResponse(xhr);
            }
            catch (err) {
                response = xhr.responseText;
            }
            this.response = response;
        };
    });
    var AjaxTimeoutErrorImpl = (function () {
        function AjaxTimeoutErrorImpl(xhr, request) {
            AjaxError.call(this, 'ajax timeout', xhr, request);
            this.name = 'AjaxTimeoutError';
            return this;
        }
        AjaxTimeoutErrorImpl.prototype = Object.create(AjaxError.prototype);
        return AjaxTimeoutErrorImpl;
    })();
    var AjaxTimeoutError = AjaxTimeoutErrorImpl;

    function ajaxGet(url, headers) {
        return ajax({ method: 'GET', url: url, headers: headers });
    }
    function ajaxPost(url, body, headers) {
        return ajax({ method: 'POST', url: url, body: body, headers: headers });
    }
    function ajaxDelete(url, headers) {
        return ajax({ method: 'DELETE', url: url, headers: headers });
    }
    function ajaxPut(url, body, headers) {
        return ajax({ method: 'PUT', url: url, body: body, headers: headers });
    }
    function ajaxPatch(url, body, headers) {
        return ajax({ method: 'PATCH', url: url, body: body, headers: headers });
    }
    var mapResponse = map(function (x) { return x.response; });
    function ajaxGetJSON(url, headers) {
        return mapResponse(ajax({
            method: 'GET',
            url: url,
            headers: headers,
        }));
    }
    var ajax = (function () {
        var create = function (urlOrRequest) {
            var request = typeof urlOrRequest === 'string'
                ? {
                    url: urlOrRequest,
                }
                : urlOrRequest;
            return fromAjax(request);
        };
        create.get = ajaxGet;
        create.post = ajaxPost;
        create.delete = ajaxDelete;
        create.put = ajaxPut;
        create.patch = ajaxPatch;
        create.getJSON = ajaxGetJSON;
        return create;
    })();
    function fromAjax(config) {
        return new Observable(function (destination) {
            var headers = {};
            var requestHeaders = config.headers;
            if (requestHeaders) {
                for (var key in requestHeaders) {
                    if (requestHeaders.hasOwnProperty(key)) {
                        headers[key.toLowerCase()] = requestHeaders[key];
                    }
                }
            }
            if (!config.crossDomain && !('x-requested-with' in headers)) {
                headers['x-requested-with'] = 'XMLHttpRequest';
            }
            var body;
            try {
                body = extractContentTypeAndMaybeSerializeBody(config.body, headers);
            }
            catch (err) {
                destination.error(err);
                return;
            }
            var _request = __assign(__assign({ async: true, crossDomain: true, withCredentials: false, method: 'GET', timeout: 0, responseType: 'json' }, config), { headers: headers,
                body: body });
            var xhr;
            try {
                var url = _request.url;
                if (!url) {
                    throw new TypeError('url is required');
                }
                xhr = config.createXHR ? config.createXHR() : new XMLHttpRequest();
                {
                    var progressSubscriber_1 = config.progressSubscriber;
                    xhr.ontimeout = function () {
                        var _a;
                        var timeoutError = new AjaxTimeoutError(xhr, _request);
                        (_a = progressSubscriber_1 === null || progressSubscriber_1 === void 0 ? void 0 : progressSubscriber_1.error) === null || _a === void 0 ? void 0 : _a.call(progressSubscriber_1, timeoutError);
                        destination.error(timeoutError);
                    };
                    if (progressSubscriber_1) {
                        xhr.upload.onprogress = function (e) {
                            var _a;
                            (_a = progressSubscriber_1.next) === null || _a === void 0 ? void 0 : _a.call(progressSubscriber_1, e);
                        };
                    }
                    xhr.onerror = function (e) {
                        var _a;
                        (_a = progressSubscriber_1 === null || progressSubscriber_1 === void 0 ? void 0 : progressSubscriber_1.error) === null || _a === void 0 ? void 0 : _a.call(progressSubscriber_1, e);
                        destination.error(new AjaxError('ajax error', xhr, _request));
                    };
                    xhr.onload = function (e) {
                        var _a, _b;
                        if (xhr.status < 400) {
                            (_a = progressSubscriber_1 === null || progressSubscriber_1 === void 0 ? void 0 : progressSubscriber_1.complete) === null || _a === void 0 ? void 0 : _a.call(progressSubscriber_1);
                            var response = void 0;
                            try {
                                response = new AjaxResponse(e, xhr, _request);
                            }
                            catch (err) {
                                destination.error(err);
                                return;
                            }
                            destination.next(response);
                            destination.complete();
                        }
                        else {
                            (_b = progressSubscriber_1 === null || progressSubscriber_1 === void 0 ? void 0 : progressSubscriber_1.error) === null || _b === void 0 ? void 0 : _b.call(progressSubscriber_1, e);
                            destination.error(new AjaxError('ajax error ' + xhr.status, xhr, _request));
                        }
                    };
                }
                var user = _request.user, method = _request.method, async = _request.async;
                if (user) {
                    xhr.open(method, url, async, user, _request.password);
                }
                else {
                    xhr.open(method, url, async);
                }
                if (async) {
                    xhr.timeout = _request.timeout;
                    xhr.responseType = _request.responseType;
                }
                if ('withCredentials' in xhr) {
                    xhr.withCredentials = _request.withCredentials;
                }
                for (var key in headers) {
                    if (headers.hasOwnProperty(key)) {
                        xhr.setRequestHeader(key, headers[key]);
                    }
                }
                if (body) {
                    xhr.send(body);
                }
                else {
                    xhr.send();
                }
            }
            catch (err) {
                destination.error(err);
            }
            return function () {
                if (xhr && xhr.readyState !== 4) {
                    xhr.abort();
                }
            };
        });
    }
    function extractContentTypeAndMaybeSerializeBody(body, headers) {
        var _a;
        if (!body ||
            typeof body === 'string' ||
            isFormData(body) ||
            isURLSearchParams(body) ||
            isArrayBuffer(body) ||
            isFile(body) ||
            isBlob(body) ||
            isReadableStream(body)) {
            return body;
        }
        if (isArrayBufferView(body)) {
            return body.buffer;
        }
        if (typeof body === 'object') {
            headers['content-type'] = (_a = headers['content-type']) !== null && _a !== void 0 ? _a : 'application/json;charset=utf-8';
            return JSON.stringify(body);
        }
        throw new TypeError('Unknown body type');
    }
    var _toString = Object.prototype.toString;
    function toStringCheck(obj, name) {
        return _toString.call(obj) === "[object " + name + "]";
    }
    function isArrayBuffer(body) {
        return toStringCheck(body, 'ArrayBuffer');
    }
    function isFile(body) {
        return toStringCheck(body, 'File');
    }
    function isBlob(body) {
        return toStringCheck(body, 'Blob');
    }
    function isArrayBufferView(body) {
        return typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView(body);
    }
    function isFormData(body) {
        return typeof FormData !== 'undefined' && body instanceof FormData;
    }
    function isURLSearchParams(body) {
        return typeof URLSearchParams !== 'undefined' && body instanceof URLSearchParams;
    }
    function isReadableStream(body) {
        return typeof ReadableStream !== 'undefined' && body instanceof ReadableStream;
    }



    var _ajax = /*#__PURE__*/Object.freeze({
        ajax: ajax,
        AjaxError: AjaxError,
        AjaxTimeoutError: AjaxTimeoutError,
        AjaxResponse: AjaxResponse
    });

    var DEFAULT_WEBSOCKET_CONFIG = {
        url: '',
        deserializer: function (e) { return JSON.parse(e.data); },
        serializer: function (value) { return JSON.stringify(value); },
    };
    var WEBSOCKETSUBJECT_INVALID_ERROR_OBJECT = 'WebSocketSubject.error must be called with an object with an error code, and an optional reason: { code: number, reason: string }';
    var WebSocketSubject = (function (_super) {
        __extends(WebSocketSubject, _super);
        function WebSocketSubject(urlConfigOrSource, destination) {
            var _this = _super.call(this) || this;
            _this._socket = null;
            if (urlConfigOrSource instanceof Observable) {
                _this.destination = destination;
                _this.source = urlConfigOrSource;
            }
            else {
                var config = _this._config = __assign({}, DEFAULT_WEBSOCKET_CONFIG);
                _this._output = new Subject();
                if (typeof urlConfigOrSource === 'string') {
                    config.url = urlConfigOrSource;
                }
                else {
                    for (var key in urlConfigOrSource) {
                        if (urlConfigOrSource.hasOwnProperty(key)) {
                            config[key] = urlConfigOrSource[key];
                        }
                    }
                }
                if (!config.WebSocketCtor && WebSocket) {
                    config.WebSocketCtor = WebSocket;
                }
                else if (!config.WebSocketCtor) {
                    throw new Error('no WebSocket constructor can be found');
                }
                _this.destination = new ReplaySubject();
            }
            return _this;
        }
        WebSocketSubject.prototype.lift = function (operator) {
            var sock = new WebSocketSubject(this._config, this.destination);
            sock.operator = operator;
            sock.source = this;
            return sock;
        };
        WebSocketSubject.prototype._resetState = function () {
            this._socket = null;
            if (!this.source) {
                this.destination = new ReplaySubject();
            }
            this._output = new Subject();
        };
        WebSocketSubject.prototype.multiplex = function (subMsg, unsubMsg, messageFilter) {
            var self = this;
            return new Observable(function (observer) {
                try {
                    self.next(subMsg());
                }
                catch (err) {
                    observer.error(err);
                }
                var subscription = self.subscribe(function (x) {
                    try {
                        if (messageFilter(x)) {
                            observer.next(x);
                        }
                    }
                    catch (err) {
                        observer.error(err);
                    }
                }, function (err) { return observer.error(err); }, function () { return observer.complete(); });
                return function () {
                    try {
                        self.next(unsubMsg());
                    }
                    catch (err) {
                        observer.error(err);
                    }
                    subscription.unsubscribe();
                };
            });
        };
        WebSocketSubject.prototype._connectSocket = function () {
            var _this = this;
            var _a = this._config, WebSocketCtor = _a.WebSocketCtor, protocol = _a.protocol, url = _a.url, binaryType = _a.binaryType;
            var observer = this._output;
            var socket = null;
            try {
                socket = protocol ?
                    new WebSocketCtor(url, protocol) :
                    new WebSocketCtor(url);
                this._socket = socket;
                if (binaryType) {
                    this._socket.binaryType = binaryType;
                }
            }
            catch (e) {
                observer.error(e);
                return;
            }
            var subscription = new Subscription(function () {
                _this._socket = null;
                if (socket && socket.readyState === 1) {
                    socket.close();
                }
            });
            socket.onopen = function (e) {
                var _socket = _this._socket;
                if (!_socket) {
                    socket.close();
                    _this._resetState();
                    return;
                }
                var openObserver = _this._config.openObserver;
                if (openObserver) {
                    openObserver.next(e);
                }
                var queue = _this.destination;
                _this.destination = Subscriber.create(function (x) {
                    if (socket.readyState === 1) {
                        try {
                            var serializer = _this._config.serializer;
                            socket.send(serializer(x));
                        }
                        catch (e) {
                            _this.destination.error(e);
                        }
                    }
                }, function (e) {
                    var closingObserver = _this._config.closingObserver;
                    if (closingObserver) {
                        closingObserver.next(undefined);
                    }
                    if (e && e.code) {
                        socket.close(e.code, e.reason);
                    }
                    else {
                        observer.error(new TypeError(WEBSOCKETSUBJECT_INVALID_ERROR_OBJECT));
                    }
                    _this._resetState();
                }, function () {
                    var closingObserver = _this._config.closingObserver;
                    if (closingObserver) {
                        closingObserver.next(undefined);
                    }
                    socket.close();
                    _this._resetState();
                });
                if (queue && queue instanceof ReplaySubject) {
                    subscription.add(queue.subscribe(_this.destination));
                }
            };
            socket.onerror = function (e) {
                _this._resetState();
                observer.error(e);
            };
            socket.onclose = function (e) {
                _this._resetState();
                var closeObserver = _this._config.closeObserver;
                if (closeObserver) {
                    closeObserver.next(e);
                }
                if (e.wasClean) {
                    observer.complete();
                }
                else {
                    observer.error(e);
                }
            };
            socket.onmessage = function (e) {
                try {
                    var deserializer = _this._config.deserializer;
                    observer.next(deserializer(e));
                }
                catch (err) {
                    observer.error(err);
                }
            };
        };
        WebSocketSubject.prototype._subscribe = function (subscriber) {
            var _this = this;
            var source = this.source;
            if (source) {
                return source.subscribe(subscriber);
            }
            if (!this._socket) {
                this._connectSocket();
            }
            this._output.subscribe(subscriber);
            subscriber.add(function () {
                var _socket = _this._socket;
                if (_this._output.observers.length === 0) {
                    if (_socket && (_socket.readyState === 1 || _socket.readyState === 0)) {
                        _socket.close();
                    }
                    _this._resetState();
                }
            });
            return subscriber;
        };
        WebSocketSubject.prototype.unsubscribe = function () {
            var _socket = this._socket;
            if (_socket && (_socket.readyState === 1 || _socket.readyState === 0)) {
                _socket.close();
            }
            this._resetState();
            _super.prototype.unsubscribe.call(this);
        };
        return WebSocketSubject;
    }(AnonymousSubject));

    function webSocket(urlConfigOrSource) {
        return new WebSocketSubject(urlConfigOrSource);
    }



    var _webSocket = /*#__PURE__*/Object.freeze({
        webSocket: webSocket,
        WebSocketSubject: WebSocketSubject
    });

    function fromFetch(input, initWithSelector) {
        if (initWithSelector === void 0) { initWithSelector = {}; }
        var selector = initWithSelector.selector, init = __rest(initWithSelector, ["selector"]);
        return new Observable(function (subscriber) {
            var controller = new AbortController();
            var signal = controller.signal;
            var abortable = true;
            var unsubscribed = false;
            var subscription = new Subscription();
            subscription.add(function () {
                unsubscribed = true;
                if (abortable) {
                    controller.abort();
                }
            });
            var perSubscriberInit;
            if (init) {
                if (init.signal) {
                    if (init.signal.aborted) {
                        controller.abort();
                    }
                    else {
                        var outerSignal_1 = init.signal;
                        var outerSignalHandler_1 = function () {
                            if (!signal.aborted) {
                                controller.abort();
                            }
                        };
                        outerSignal_1.addEventListener('abort', outerSignalHandler_1);
                        subscription.add(function () { return outerSignal_1.removeEventListener('abort', outerSignalHandler_1); });
                    }
                }
                perSubscriberInit = __assign(__assign({}, init), { signal: signal });
            }
            else {
                perSubscriberInit = { signal: signal };
            }
            fetch(input, perSubscriberInit).then(function (response) {
                if (selector) {
                    subscription.add(from(selector(response)).subscribe(function (value) { return subscriber.next(value); }, function (err) {
                        abortable = false;
                        if (!unsubscribed) {
                            subscriber.error(err);
                        }
                    }, function () {
                        abortable = false;
                        subscriber.complete();
                    }));
                }
                else {
                    abortable = false;
                    subscriber.next(response);
                    subscriber.complete();
                }
            }).catch(function (err) {
                abortable = false;
                if (!unsubscribed) {
                    subscriber.error(err);
                }
            });
            return subscription;
        });
    }



    var _fetch = /*#__PURE__*/Object.freeze({
        fromFetch: fromFetch
    });

    var operators = _operators;
    var testing = _testing;
    var ajax$1 = _ajax;
    var webSocket$1 = _webSocket;
    var fetch$1 = _fetch;

    exports.operators = operators;
    exports.testing = testing;
    exports.ajax = ajax$1;
    exports.webSocket = webSocket$1;
    exports.fetch = fetch$1;
    exports.Observable = Observable;
    exports.ConnectableObservable = ConnectableObservable;
    exports.observable = observable;
    exports.animationFrames = animationFrames;
    exports.Subject = Subject;
    exports.BehaviorSubject = BehaviorSubject;
    exports.ReplaySubject = ReplaySubject;
    exports.AsyncSubject = AsyncSubject;
    exports.asap = asap;
    exports.asapScheduler = asapScheduler;
    exports.async = async;
    exports.asyncScheduler = asyncScheduler;
    exports.queue = queue;
    exports.queueScheduler = queueScheduler;
    exports.animationFrame = animationFrame;
    exports.animationFrameScheduler = animationFrameScheduler;
    exports.VirtualTimeScheduler = VirtualTimeScheduler;
    exports.VirtualAction = VirtualAction;
    exports.Scheduler = Scheduler;
    exports.Subscription = Subscription;
    exports.Subscriber = Subscriber;
    exports.Notification = Notification;
    exports.pipe = pipe;
    exports.noop = noop;
    exports.identity = identity;
    exports.isObservable = isObservable;
    exports.lastValueFrom = lastValueFrom;
    exports.firstValueFrom = firstValueFrom;
    exports.ArgumentOutOfRangeError = ArgumentOutOfRangeError;
    exports.EmptyError = EmptyError;
    exports.NotFoundError = NotFoundError;
    exports.ObjectUnsubscribedError = ObjectUnsubscribedError;
    exports.SequenceError = SequenceError;
    exports.TimeoutError = TimeoutError;
    exports.UnsubscriptionError = UnsubscriptionError;
    exports.bindCallback = bindCallback;
    exports.bindNodeCallback = bindNodeCallback;
    exports.combineLatest = combineLatest;
    exports.concat = concat;
    exports.defer = defer;
    exports.empty = empty;
    exports.forkJoin = forkJoin;
    exports.from = from;
    exports.fromEvent = fromEvent;
    exports.fromEventPattern = fromEventPattern;
    exports.generate = generate;
    exports.iif = iif;
    exports.interval = interval;
    exports.merge = merge;
    exports.never = never;
    exports.of = of;
    exports.onErrorResumeNext = onErrorResumeNext$1;
    exports.pairs = pairs;
    exports.partition = partition;
    exports.race = race;
    exports.range = range;
    exports.throwError = throwError;
    exports.timer = timer;
    exports.using = using;
    exports.zip = zip;
    exports.scheduled = scheduled;
    exports.EMPTY = EMPTY;
    exports.NEVER = NEVER;
    exports.config = config;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=rxjs.umd.js.map

