"use strict";
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindNodeCallback = void 0;
var Observable_1 = require("../Observable");
var isScheduler_1 = require("../util/isScheduler");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
function bindNodeCallback(callbackFunc, resultSelector, scheduler) {
    if (resultSelector) {
        if (isScheduler_1.isScheduler(resultSelector)) {
            scheduler = resultSelector;
        }
        else {
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return bindNodeCallback(callbackFunc, scheduler).apply(void 0, args).pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector));
            };
        }
    }
    return function () {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var results;
        var hasResults = false;
        var hasError = false;
        var error;
        return new Observable_1.Observable(function (subscriber) {
            if (!scheduler) {
                var isCurrentlyAsync_1 = false;
                var hasCompletedSynchronously_1 = false;
                if (hasResults) {
                    subscriber.next(results);
                    subscriber.complete();
                }
                else if (hasError) {
                    subscriber.error(error);
                }
                else {
                    var handler = function () {
                        var innerArgs = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            innerArgs[_i] = arguments[_i];
                        }
                        var err = innerArgs.shift();
                        if (err != null) {
                            hasError = true;
                            error = err;
                            subscriber.error(err);
                        }
                        else {
                            hasResults = true;
                            results = innerArgs.length <= 1 ? innerArgs[0] : innerArgs;
                            subscriber.next(results);
                            if (isCurrentlyAsync_1) {
                                subscriber.complete();
                            }
                            else {
                                hasCompletedSynchronously_1 = true;
                            }
                        }
                    };
                    try {
                        callbackFunc.apply(_this, __spreadArrays(args, [handler]));
                    }
                    catch (err) {
                        hasError = true;
                        error = err;
                        subscriber.error(err);
                    }
                    isCurrentlyAsync_1 = true;
                    if (hasCompletedSynchronously_1 && !hasError) {
                        subscriber.complete();
                    }
                }
                return;
            }
            else {
                var scheduleNext_1 = function (value) {
                    hasResults = true;
                    results = value.length <= 1 ? value[0] : value;
                    subscriber.add(scheduler.schedule(function () {
                        subscriber.next(results);
                        subscriber.add(scheduler.schedule(function () {
                            subscriber.complete();
                        }));
                    }));
                };
                var scheduleError_1 = function (err) {
                    hasError = true;
                    error = err;
                    subscriber.add(scheduler.schedule(function () {
                        subscriber.error(error);
                    }));
                };
                return scheduler.schedule(function () {
                    if (hasResults) {
                        scheduleNext_1(results);
                    }
                    else if (hasError) {
                        scheduleError_1(error);
                    }
                    else {
                        try {
                            callbackFunc.apply(_this, __spreadArrays(args, [
                                function () {
                                    var innerArgs = [];
                                    for (var _i = 0; _i < arguments.length; _i++) {
                                        innerArgs[_i] = arguments[_i];
                                    }
                                    var err = innerArgs.shift();
                                    if (err != null) {
                                        scheduleError_1(err);
                                    }
                                    else {
                                        scheduleNext_1(innerArgs);
                                    }
                                },
                            ]));
                        }
                        catch (err) {
                            scheduleError_1(err);
                            return;
                        }
                    }
                });
            }
        });
    };
}
exports.bindNodeCallback = bindNodeCallback;
//# sourceMappingURL=bindNodeCallback.js.map