"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.from = void 0;
var subscribeToArray_1 = require("../util/subscribeToArray");
var subscribeToPromise_1 = require("../util/subscribeToPromise");
var subscribeToIterable_1 = require("../util/subscribeToIterable");
var subscribeToObservable_1 = require("../util/subscribeToObservable");
var isArrayLike_1 = require("../util/isArrayLike");
var isPromise_1 = require("../util/isPromise");
var isObject_1 = require("../util/isObject");
var iterator_1 = require("../symbol/iterator");
var observable_1 = require("../symbol/observable");
var subscribeToAsyncIterable_1 = require("../util/subscribeToAsyncIterable");
var Observable_1 = require("../Observable");
var scheduled_1 = require("../scheduled/scheduled");
function from(input, scheduler) {
    if (!scheduler) {
        if (input instanceof Observable_1.Observable) {
            return input;
        }
        return new Observable_1.Observable(subscribeTo(input));
    }
    else {
        return scheduled_1.scheduled(input, scheduler);
    }
}
exports.from = from;
function subscribeTo(result) {
    if (result && typeof result[observable_1.observable] === 'function') {
        return subscribeToObservable_1.subscribeToObservable(result);
    }
    else if (isArrayLike_1.isArrayLike(result)) {
        return subscribeToArray_1.subscribeToArray(result);
    }
    else if (isPromise_1.isPromise(result)) {
        return subscribeToPromise_1.subscribeToPromise(result);
    }
    else if (result && typeof result[iterator_1.iterator] === 'function') {
        return subscribeToIterable_1.subscribeToIterable(result);
    }
    else if (Symbol && Symbol.asyncIterator &&
        !!result && typeof result[Symbol.asyncIterator] === 'function') {
        return subscribeToAsyncIterable_1.subscribeToAsyncIterable(result);
    }
    else {
        var value = isObject_1.isObject(result) ? 'an invalid object' : "'" + result + "'";
        var msg = "You provided " + value + " where a stream was expected."
            + ' You can provide an Observable, Promise, Array, AsyncIterable, or Iterable.';
        throw new TypeError(msg);
    }
}
;
//# sourceMappingURL=from.js.map