"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromEvent = void 0;
var Observable_1 = require("../Observable");
var mergeMap_1 = require("../operators/mergeMap");
var isArrayLike_1 = require("../util/isArrayLike");
var isFunction_1 = require("../util/isFunction");
var mapOneOrManyArgs_1 = require("../util/mapOneOrManyArgs");
var fromArray_1 = require("./fromArray");
function fromEvent(target, eventName, options, resultSelector) {
    if (isFunction_1.isFunction(options)) {
        resultSelector = options;
        options = undefined;
    }
    if (resultSelector) {
        return fromEvent(target, eventName, options).pipe(mapOneOrManyArgs_1.mapOneOrManyArgs(resultSelector));
    }
    return new Observable_1.Observable(function (subscriber) {
        var handler = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return subscriber.next(args.length > 1 ? args : args[0]);
        };
        if (isEventTarget(target)) {
            target.addEventListener(eventName, handler, options);
            return function () { return target.removeEventListener(eventName, handler, options); };
        }
        if (isJQueryStyleEventEmitter(target)) {
            target.on(eventName, handler);
            return function () { return target.off(eventName, handler); };
        }
        if (isNodeStyleEventEmitter(target)) {
            target.addListener(eventName, handler);
            return function () { return target.removeListener(eventName, handler); };
        }
        if (isArrayLike_1.isArrayLike(target)) {
            return mergeMap_1.mergeMap(function (target) { return fromEvent(target, eventName, options); })(fromArray_1.fromArray(target)).subscribe(subscriber);
        }
        subscriber.error(new TypeError('Invalid event target'));
        return;
    });
}
exports.fromEvent = fromEvent;
function isNodeStyleEventEmitter(sourceObj) {
    return sourceObj && typeof sourceObj.addListener === 'function' && typeof sourceObj.removeListener === 'function';
}
function isJQueryStyleEventEmitter(sourceObj) {
    return sourceObj && typeof sourceObj.on === 'function' && typeof sourceObj.off === 'function';
}
function isEventTarget(sourceObj) {
    return sourceObj && typeof sourceObj.addEventListener === 'function' && typeof sourceObj.removeEventListener === 'function';
}
//# sourceMappingURL=fromEvent.js.map