"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = void 0;
var Observable_1 = require("../Observable");
var identity_1 = require("../util/identity");
var isScheduler_1 = require("../util/isScheduler");
function generate(initialStateOrOptions, condition, iterate, resultSelectorOrScheduler, scheduler) {
    var resultSelector;
    var initialState;
    if (arguments.length == 1) {
        var options = initialStateOrOptions;
        initialState = options.initialState;
        condition = options.condition;
        iterate = options.iterate;
        resultSelector = options.resultSelector || identity_1.identity;
        scheduler = options.scheduler;
    }
    else {
        initialState = initialStateOrOptions;
        if (!resultSelectorOrScheduler || isScheduler_1.isScheduler(resultSelectorOrScheduler)) {
            resultSelector = identity_1.identity;
            scheduler = resultSelectorOrScheduler;
        }
        else {
            resultSelector = resultSelectorOrScheduler;
        }
    }
    return new Observable_1.Observable(function (subscriber) {
        var state = initialState;
        if (scheduler) {
            var needIterate_1 = false;
            return scheduler.schedule(function () {
                if (!subscriber.closed) {
                    try {
                        needIterate_1 ? (state = iterate(state)) : (needIterate_1 = true);
                        condition && !condition(state) ? subscriber.complete() : subscriber.next(resultSelector(state));
                    }
                    catch (err) {
                        subscriber.error(err);
                    }
                    if (!subscriber.closed) {
                        this.schedule(state);
                    }
                }
            });
        }
        try {
            do {
                if (condition && !condition(state)) {
                    subscriber.complete();
                }
                else {
                    subscriber.next(resultSelector(state));
                    !subscriber.closed && (state = iterate(state));
                }
            } while (!subscriber.closed);
        }
        catch (err) {
            subscriber.error(err);
        }
        return undefined;
    });
}
exports.generate = generate;
//# sourceMappingURL=generate.js.map