"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = void 0;
var isScheduler_1 = require("../util/isScheduler");
var mergeAll_1 = require("../operators/mergeAll");
var fromArray_1 = require("./fromArray");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var from_1 = require("./from");
var empty_1 = require("./empty");
function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var concurrent = Infinity;
    var scheduler = undefined;
    if (isScheduler_1.isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    if (typeof args[args.length - 1] === 'number') {
        concurrent = args.pop();
    }
    args = argsOrArgArray_1.argsOrArgArray(args);
    return !args.length
        ?
            empty_1.EMPTY
        : args.length === 1
            ?
                from_1.from(args[0])
            :
                mergeAll_1.mergeAll(concurrent)(fromArray_1.fromArray(args, scheduler));
}
exports.merge = merge;
//# sourceMappingURL=merge.js.map