"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwError = void 0;
var Observable_1 = require("../Observable");
function throwError(errorOrErrorFactory, scheduler) {
    if (!scheduler) {
        return new Observable_1.Observable(function (subscriber) {
            return subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
        });
    }
    else {
        return new Observable_1.Observable(function (subscriber) {
            return scheduler.schedule(function () {
                subscriber.error(typeof errorOrErrorFactory === 'function' ? errorOrErrorFactory() : errorOrErrorFactory);
            });
        });
    }
}
exports.throwError = throwError;
//# sourceMappingURL=throwError.js.map