"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zip = void 0;
var Observable_1 = require("../Observable");
var Subscription_1 = require("../Subscription");
var from_1 = require("./from");
function zip() {
    var sources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        sources[_i] = arguments[_i];
    }
    var resultSelector = undefined;
    if (typeof sources[sources.length - 1] === 'function') {
        resultSelector = sources.pop();
    }
    return new Observable_1.Observable(function (subscriber) {
        var buffers = sources.map(function () { return []; });
        var completed = sources.map(function () { return false; });
        var subscription = new Subscription_1.Subscription();
        var tryEmit = function () {
            if (buffers.every(function (buffer) { return buffer.length > 0; })) {
                var result = buffers.map(function (buffer) { return buffer.shift(); });
                if (resultSelector) {
                    try {
                        result = resultSelector.apply(void 0, result);
                    }
                    catch (err) {
                        subscriber.error(err);
                        return;
                    }
                }
                subscriber.next(result);
                if (buffers.some(function (buffer, i) { return buffer.length === 0 && completed[i]; })) {
                    subscriber.complete();
                }
            }
        };
        var _loop_1 = function (i) {
            var source = from_1.from(sources[i]);
            subscription.add(source.subscribe({
                next: function (value) {
                    buffers[i].push(value);
                    tryEmit();
                },
                error: function (err) { return subscriber.error(err); },
                complete: function () {
                    completed[i] = true;
                    if (buffers[i].length === 0) {
                        subscriber.complete();
                    }
                },
            }));
        };
        for (var i = 0; !subscriber.closed && i < sources.length; i++) {
            _loop_1(i);
        }
        return subscription;
    });
}
exports.zip = zip;
//# sourceMappingURL=zip.js.map