"use strict";
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.concat = exports.concatWith = void 0;
var lift_1 = require("../util/lift");
var concatAll_1 = require("./concatAll");
var fromArray_1 = require("../observable/fromArray");
var isScheduler_1 = require("../util/isScheduler");
function concatWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return concat.apply(void 0, otherSources);
}
exports.concatWith = concatWith;
function concat() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var scheduler;
    if (isScheduler_1.isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    return lift_1.operate(function (source, subscriber) {
        concatAll_1.concatAll()(fromArray_1.fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
    });
}
exports.concat = concat;
//# sourceMappingURL=concatWith.js.map