"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.debounceTime = void 0;
var async_1 = require("../scheduler/async");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function debounceTime(dueTime, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var lastValue = null;
        var debounceSubscription = null;
        var emitLastValue = function () {
            hasValue = false;
            var value = lastValue;
            lastValue = null;
            subscriber.next(value);
        };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            debounceSubscription === null || debounceSubscription === void 0 ? void 0 : debounceSubscription.unsubscribe();
            hasValue = true;
            lastValue = value;
            subscriber.add((debounceSubscription = scheduler.schedule(function () {
                debounceSubscription = null;
                emitLastValue();
            }, dueTime)));
        }, undefined, function () {
            hasValue && emitLastValue();
            subscriber.complete();
        }));
    });
}
exports.debounceTime = debounceTime;
//# sourceMappingURL=debounceTime.js.map