"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delay = void 0;
var async_1 = require("../scheduler/async");
var isDate_1 = require("../util/isDate");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function delay(delay, scheduler) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    return lift_1.operate(function (source, subscriber) {
        var isAbsoluteDelay = isDate_1.isValidDate(delay);
        var isComplete = false;
        var active = 0;
        var absoluteTimeValues = isAbsoluteDelay ? [] : null;
        var checkComplete = function () { return isComplete && !active && !(absoluteTimeValues === null || absoluteTimeValues === void 0 ? void 0 : absoluteTimeValues.length) && subscriber.complete(); };
        if (isAbsoluteDelay) {
            active++;
            subscriber.add(scheduler.schedule(function () {
                active--;
                if (absoluteTimeValues) {
                    var values = absoluteTimeValues;
                    absoluteTimeValues = null;
                    for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
                        var value = values_1[_i];
                        subscriber.next(value);
                    }
                }
                checkComplete();
            }, +delay - scheduler.now()));
        }
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            if (isAbsoluteDelay) {
                absoluteTimeValues ? absoluteTimeValues.push(value) : subscriber.next(value);
            }
            else {
                active++;
                subscriber.add(scheduler.schedule(function () {
                    active--;
                    subscriber.next(value);
                    checkComplete();
                }, delay));
            }
        }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
        return function () {
            absoluteTimeValues = null;
        };
    });
}
exports.delay = delay;
//# sourceMappingURL=delay.js.map