"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.delayWhen = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var concat_1 = require("../observable/concat");
var take_1 = require("./take");
var ignoreElements_1 = require("./ignoreElements");
function delayWhen(delayDurationSelector, subscriptionDelay) {
    if (subscriptionDelay) {
        return function (source) {
            return concat_1.concat(subscriptionDelay.pipe(take_1.take(1), ignoreElements_1.ignoreElements()), source.pipe(delayWhen(delayDurationSelector)));
        };
    }
    return lift_1.operate(function (source, subscriber) {
        var index = 0;
        var isComplete = false;
        var active = 0;
        var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            var closed = false;
            var notify = function () {
                subscriber.next(value);
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                if (!closed) {
                    active--;
                    closed = true;
                    checkComplete();
                }
            };
            var durationSubscriber = new OperatorSubscriber_1.OperatorSubscriber(subscriber, notify, undefined, notify);
            active++;
            delayDurationSelector(value, index++).subscribe(durationSubscriber);
        }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
    });
}
exports.delayWhen = delayWhen;
//# sourceMappingURL=delayWhen.js.map