"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expand = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var from_1 = require("../observable/from");
function expand(project, concurrent, scheduler) {
    if (concurrent === void 0) { concurrent = Infinity; }
    concurrent = (concurrent || 0) < 1 ? Infinity : concurrent;
    return lift_1.operate(function (source, subscriber) {
        var active = 0;
        var buffer = [];
        var index = 0;
        var isComplete = false;
        var emitAndExpand = function (value) {
            subscriber.next(value);
            var inner = from_1.from(project(value, index++));
            active++;
            var doSub = function () {
                inner.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, next, undefined, function () {
                    --active === 0 && isComplete && !buffer.length ? subscriber.complete() : trySub();
                }));
            };
            scheduler ? subscriber.add(scheduler.schedule(doSub)) : doSub();
        };
        var trySub = function () {
            while (0 < buffer.length && active < concurrent) {
                emitAndExpand(buffer.shift());
            }
        };
        var next = function (value) { return (active < concurrent ? emitAndExpand(value) : buffer.push(value)); };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, next, undefined, function () {
            isComplete = true;
            active === 0 && subscriber.complete();
        }));
        return function () {
            buffer = null;
        };
    });
}
exports.expand = expand;
//# sourceMappingURL=expand.js.map