"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupBy = void 0;
var Observable_1 = require("../Observable");
var Subject_1 = require("../Subject");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function groupBy(keySelector, elementSelector, durationSelector, subjectSelector) {
    return lift_1.operate(function (source, subscriber) {
        var groups = new Map();
        var notify = function (cb) {
            groups.forEach(cb);
            cb(subscriber);
        };
        var groupBySourceSubscriber = new GroupBySubscriber(subscriber, function (value) {
            var key = keySelector(value);
            var group = groups.get(key);
            if (!group) {
                groups.set(key, (group = subjectSelector ? subjectSelector() : new Subject_1.Subject()));
                var grouped = createGroupedObservable(key, group);
                subscriber.next(grouped);
                if (durationSelector) {
                    var durationSubscriber_1 = new OperatorSubscriber_1.OperatorSubscriber(group, function () {
                        group.complete();
                        durationSubscriber_1 === null || durationSubscriber_1 === void 0 ? void 0 : durationSubscriber_1.unsubscribe();
                    }, undefined, undefined, function () { return groups.delete(key); });
                    groupBySourceSubscriber.add(durationSelector(grouped).subscribe(durationSubscriber_1));
                }
            }
            group.next(elementSelector ? elementSelector(value) : value);
        }, function (err) { return notify(function (consumer) { return consumer.error(err); }); }, function () { return notify(function (consumer) { return consumer.complete(); }); }, function () { return groups.clear(); });
        source.subscribe(groupBySourceSubscriber);
        function createGroupedObservable(key, groupSubject) {
            var result = new Observable_1.Observable(function (groupSubscriber) {
                groupBySourceSubscriber.activeGroups++;
                var innerSub = groupSubject.subscribe(groupSubscriber);
                return function () {
                    innerSub.unsubscribe();
                    --groupBySourceSubscriber.activeGroups === 0 &&
                        groupBySourceSubscriber.teardownAttempted &&
                        groupBySourceSubscriber.unsubscribe();
                };
            });
            result.key = key;
            return result;
        }
    });
}
exports.groupBy = groupBy;
var GroupBySubscriber = (function (_super) {
    __extends(GroupBySubscriber, _super);
    function GroupBySubscriber() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.activeGroups = 0;
        _this.teardownAttempted = false;
        return _this;
    }
    GroupBySubscriber.prototype.unsubscribe = function () {
        this.teardownAttempted = true;
        this.activeGroups === 0 && _super.prototype.unsubscribe.call(this);
    };
    return GroupBySubscriber;
}(OperatorSubscriber_1.OperatorSubscriber));
//# sourceMappingURL=groupBy.js.map