"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatMap = exports.mergeMap = void 0;
var map_1 = require("./map");
var from_1 = require("../observable/from");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function mergeMap(project, resultSelector, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    if (typeof resultSelector === 'function') {
        return function (source) {
            return source.pipe(mergeMap(function (a, i) { return from_1.from(project(a, i)).pipe(map_1.map(function (b, ii) { return resultSelector(a, b, i, ii); })); }, concurrent));
        };
    }
    else if (typeof resultSelector === 'number') {
        concurrent = resultSelector;
    }
    return lift_1.operate(function (source, subscriber) {
        var isComplete = false;
        var active = 0;
        var index = 0;
        var buffer = [];
        var checkComplete = function () { return isComplete && !active && subscriber.complete(); };
        var tryInnerSub = function () {
            while (active < concurrent && buffer.length > 0) {
                doInnerSub(buffer.shift());
            }
        };
        var doInnerSub = function (value) {
            active++;
            subscriber.add(from_1.from(project(value, index++)).subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (innerValue) { return subscriber.next(innerValue); }, undefined, function () {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            })));
        };
        var outerSubs;
        outerSubs = source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
            isComplete = true;
            checkComplete();
            outerSubs === null || outerSubs === void 0 ? void 0 : outerSubs.unsubscribe();
        }));
        return function () {
            buffer = null;
        };
    });
}
exports.mergeMap = mergeMap;
exports.flatMap = mergeMap;
//# sourceMappingURL=mergeMap.js.map