"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeScan = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var from_1 = require("../observable/from");
function mergeScan(accumulator, seed, concurrent) {
    if (concurrent === void 0) { concurrent = Infinity; }
    return lift_1.operate(function (source, subscriber) {
        var buffer = [];
        var active = 0;
        var hasState = false;
        var state = seed;
        var index = 0;
        var isComplete = false;
        var checkComplete = function () {
            if (isComplete && !buffer.length && !active) {
                !hasState && subscriber.next(state);
                subscriber.complete();
            }
        };
        var doInnerSub = function (value) {
            active++;
            from_1.from(accumulator(state, value, index++)).subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (innerValue) {
                hasState = true;
                subscriber.next((state = innerValue));
            }, undefined, function () {
                active--;
                buffer.length && tryInnerSub();
                checkComplete();
            }));
        };
        var tryInnerSub = function () {
            while (buffer.length && active < concurrent) {
                doInnerSub(buffer.shift());
            }
        };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) { return (active < concurrent ? doInnerSub(value) : buffer.push(value)); }, undefined, function () {
            isComplete = true;
            checkComplete();
        }));
        return function () {
            buffer = null;
        };
    });
}
exports.mergeScan = mergeScan;
//# sourceMappingURL=mergeScan.js.map