"use strict";
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeWith = exports.merge = void 0;
var lift_1 = require("../util/lift");
var isScheduler_1 = require("../util/isScheduler");
var argsOrArgArray_1 = require("../util/argsOrArgArray");
var fromArray_1 = require("../observable/fromArray");
var mergeAll_1 = require("./mergeAll");
function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var concurrent = Infinity;
    var scheduler = undefined;
    if (isScheduler_1.isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    if (typeof args[args.length - 1] === 'number') {
        concurrent = args.pop();
    }
    args = argsOrArgArray_1.argsOrArgArray(args);
    return lift_1.operate(function (source, subscriber) {
        mergeAll_1.mergeAll(concurrent)(fromArray_1.fromArray(__spreadArrays([source], args), scheduler)).subscribe(subscriber);
    });
}
exports.merge = merge;
function mergeWith() {
    var otherSources = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        otherSources[_i] = arguments[_i];
    }
    return merge.apply(void 0, otherSources);
}
exports.mergeWith = mergeWith;
//# sourceMappingURL=mergeWith.js.map