"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scan = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function scan(accumulator, seed) {
    var hasSeed = arguments.length >= 2;
    return lift_1.operate(function (source, subscriber) {
        var hasState = hasSeed;
        var state = seed;
        var index = 0;
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            var i = index++;
            subscriber.next((state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value)));
        }));
    });
}
exports.scan = scan;
//# sourceMappingURL=scan.js.map