"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttle = exports.defaultThrottleConfig = void 0;
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
var from_1 = require("../observable/from");
exports.defaultThrottleConfig = {
    leading: true,
    trailing: false,
};
function throttle(durationSelector, _a) {
    var _b = _a === void 0 ? exports.defaultThrottleConfig : _a, leading = _b.leading, trailing = _b.trailing;
    return lift_1.operate(function (source, subscriber) {
        var hasValue = false;
        var sendValue = null;
        var throttled = null;
        var throttlingDone = function () {
            throttled === null || throttled === void 0 ? void 0 : throttled.unsubscribe();
            throttled = null;
            trailing && send();
        };
        var throttle = function (value) {
            return (throttled = from_1.from(durationSelector(value)).subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, throttlingDone, undefined, throttlingDone)));
        };
        var send = function () {
            if (hasValue) {
                subscriber.next(sendValue);
                throttle(sendValue);
            }
            hasValue = false;
            sendValue = null;
        };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            hasValue = true;
            sendValue = value;
            !throttled && (leading ? send() : throttle(value));
        }));
    });
}
exports.throttle = throttle;
//# sourceMappingURL=throttle.js.map