"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttleTime = void 0;
var async_1 = require("../scheduler/async");
var throttle_1 = require("./throttle");
var lift_1 = require("../util/lift");
var OperatorSubscriber_1 = require("./OperatorSubscriber");
function throttleTime(duration, scheduler, _a) {
    if (scheduler === void 0) { scheduler = async_1.asyncScheduler; }
    var _b = _a === void 0 ? throttle_1.defaultThrottleConfig : _a, _c = _b.leading, leading = _c === void 0 ? false : _c, _d = _b.trailing, trailing = _d === void 0 ? false : _d;
    return lift_1.operate(function (source, subscriber) {
        var hasTrailingValue = false;
        var trailingValue = null;
        var throttleSubs = null;
        var isComplete = false;
        var throttleJob = function () {
            throttleSubs = null;
            if (trailing && hasTrailingValue) {
                hasTrailingValue = false;
                emit(trailingValue);
                trailingValue = null;
            }
            if (isComplete) {
                subscriber.complete();
            }
        };
        var startThrottle = function () { return subscriber.add((throttleSubs = scheduler.schedule(throttleJob, duration))); };
        var setTrailing = function (value) {
            if (trailing) {
                hasTrailingValue = true;
                trailingValue = value;
            }
        };
        var emit = function (value) {
            subscriber.next(value);
            !isComplete && startThrottle();
        };
        source.subscribe(new OperatorSubscriber_1.OperatorSubscriber(subscriber, function (value) {
            if (throttleSubs) {
                setTrailing(value);
            }
            else {
                if (leading) {
                    emit(value);
                }
                else {
                    setTrailing(value);
                    startThrottle();
                }
            }
        }, undefined, function () {
            isComplete = true;
            (!trailing || !throttleSubs || !hasTrailingValue) && subscriber.complete();
        }));
    });
}
exports.throttleTime = throttleTime;
//# sourceMappingURL=throttleTime.js.map