"use strict";
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zipAll = void 0;
var lift_1 = require("../util/lift");
var zip_1 = require("../observable/zip");
function zipAll(project) {
    return lift_1.operate(function (source, subscriber) {
        var sources = [];
        subscriber.add(source.subscribe({
            next: function (source) { return sources.push(source); },
            error: function (err) { return subscriber.error(err); },
            complete: function () {
                if (sources.length > 0) {
                    var args = project ? __spreadArrays(sources, [project]) : sources;
                    subscriber.add(zip_1.zip.apply(void 0, args).subscribe(subscriber));
                }
                else {
                    subscriber.complete();
                }
            },
        }));
    });
}
exports.zipAll = zipAll;
//# sourceMappingURL=zipAll.js.map