"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribeToPromise = void 0;
var reportUnhandledError_1 = require("./reportUnhandledError");
exports.subscribeToPromise = function (promise) { return function (subscriber) {
    promise.then(function (value) {
        if (!subscriber.closed) {
            subscriber.next(value);
            subscriber.complete();
        }
    }, function (err) { return subscriber.error(err); })
        .then(null, reportUnhandledError_1.reportUnhandledError);
    return subscriber;
}; };
//# sourceMappingURL=subscribeToPromise.js.map