import { Observable } from '../Observable';
import { isScheduler } from '../util/isScheduler';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs';
export function bindCallback(callbackFunc, resultSelector, scheduler) {
    if (resultSelector) {
        if (isScheduler(resultSelector)) {
            scheduler = resultSelector;
        }
        else {
            return (...args) => bindCallback(callbackFunc, scheduler)(...args).pipe(mapOneOrManyArgs(resultSelector));
        }
    }
    return function (...args) {
        let results;
        let hasResults = false;
        let hasError = false;
        let error;
        return new Observable((subscriber) => {
            if (!scheduler) {
                let isCurrentlyAsync = false;
                let hasCompletedSynchronously = false;
                if (hasResults) {
                    subscriber.next(results);
                    subscriber.complete();
                }
                else if (hasError) {
                    subscriber.error(error);
                }
                else {
                    const handler = (...innerArgs) => {
                        hasResults = true;
                        results = innerArgs.length <= 1 ? innerArgs[0] : innerArgs;
                        subscriber.next(results);
                        if (isCurrentlyAsync) {
                            subscriber.complete();
                        }
                        else {
                            hasCompletedSynchronously = true;
                        }
                    };
                    try {
                        callbackFunc.apply(this, [...args, handler]);
                    }
                    catch (err) {
                        hasError = true;
                        error = err;
                        subscriber.error(err);
                    }
                    isCurrentlyAsync = true;
                    if (hasCompletedSynchronously && !hasError) {
                        subscriber.complete();
                    }
                }
                return;
            }
            else {
                const scheduleNext = (value) => {
                    hasResults = true;
                    results = value.length <= 1 ? value[0] : value;
                    subscriber.add(scheduler.schedule(() => {
                        subscriber.next(results);
                        subscriber.add(scheduler.schedule(() => {
                            subscriber.complete();
                        }));
                    }));
                };
                const scheduleError = (err) => {
                    hasError = true;
                    error = err;
                    subscriber.add(scheduler.schedule(() => {
                        subscriber.error(error);
                    }));
                };
                return scheduler.schedule(() => {
                    if (hasResults) {
                        scheduleNext(results);
                    }
                    else if (hasError) {
                        scheduleError(error);
                    }
                    else {
                        try {
                            callbackFunc.apply(this, [
                                ...args,
                                (...innerArgs) => scheduleNext(innerArgs)
                            ]);
                        }
                        catch (err) {
                            scheduleError(err);
                            return;
                        }
                    }
                });
            }
        });
    };
}
//# sourceMappingURL=bindCallback.js.map