import { Observable } from '../Observable';
import { from } from './from';
export function defer(observableFactory) {
    return new Observable(subscriber => {
        let input;
        try {
            input = observableFactory();
        }
        catch (err) {
            subscriber.error(err);
            return undefined;
        }
        const source = from(input);
        return source.subscribe(subscriber);
    });
}
//# sourceMappingURL=defer.js.map