import { Observable } from '../Observable';
import { mergeMap } from '../operators/mergeMap';
import { isArrayLike } from '../util/isArrayLike';
import { isFunction } from '../util/isFunction';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs';
import { fromArray } from './fromArray';
export function fromEvent(target, eventName, options, resultSelector) {
    if (isFunction(options)) {
        resultSelector = options;
        options = undefined;
    }
    if (resultSelector) {
        return fromEvent(target, eventName, options).pipe(mapOneOrManyArgs(resultSelector));
    }
    return new Observable((subscriber) => {
        const handler = (...args) => subscriber.next(args.length > 1 ? args : args[0]);
        if (isEventTarget(target)) {
            target.addEventListener(eventName, handler, options);
            return () => target.removeEventListener(eventName, handler, options);
        }
        if (isJQueryStyleEventEmitter(target)) {
            target.on(eventName, handler);
            return () => target.off(eventName, handler);
        }
        if (isNodeStyleEventEmitter(target)) {
            target.addListener(eventName, handler);
            return () => target.removeListener(eventName, handler);
        }
        if (isArrayLike(target)) {
            return mergeMap((target) => fromEvent(target, eventName, options))(fromArray(target)).subscribe(subscriber);
        }
        subscriber.error(new TypeError('Invalid event target'));
        return;
    });
}
function isNodeStyleEventEmitter(sourceObj) {
    return sourceObj && typeof sourceObj.addListener === 'function' && typeof sourceObj.removeListener === 'function';
}
function isJQueryStyleEventEmitter(sourceObj) {
    return sourceObj && typeof sourceObj.on === 'function' && typeof sourceObj.off === 'function';
}
function isEventTarget(sourceObj) {
    return sourceObj && typeof sourceObj.addEventListener === 'function' && typeof sourceObj.removeEventListener === 'function';
}
//# sourceMappingURL=fromEvent.js.map