import { isScheduler } from '../util/isScheduler';
import { mergeAll } from '../operators/mergeAll';
import { fromArray } from './fromArray';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { from } from './from';
import { EMPTY } from './empty';
export function merge(...args) {
    let concurrent = Infinity;
    let scheduler = undefined;
    if (isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    if (typeof args[args.length - 1] === 'number') {
        concurrent = args.pop();
    }
    args = argsOrArgArray(args);
    return !args.length
        ?
            EMPTY
        : args.length === 1
            ?
                from(args[0])
            :
                mergeAll(concurrent)(fromArray(args, scheduler));
}
//# sourceMappingURL=merge.js.map