import { Observable } from '../Observable';
import { from } from './from';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { OperatorSubscriber } from '../operators/OperatorSubscriber';
export function race(...sources) {
    sources = argsOrArgArray(sources);
    return sources.length === 1 ? from(sources[0]) : new Observable(raceInit(sources));
}
export function raceInit(sources) {
    return (subscriber) => {
        let subscriptions = [];
        for (let i = 0; subscriptions && !subscriber.closed && i < sources.length; i++) {
            subscriptions.push(from(sources[i]).subscribe(new OperatorSubscriber(subscriber, (value) => {
                if (subscriptions) {
                    for (let s = 0; s < subscriptions.length; s++) {
                        s !== i && subscriptions[s].unsubscribe();
                    }
                    subscriptions = null;
                }
                subscriber.next(value);
            })));
        }
    };
}
//# sourceMappingURL=race.js.map