import { Observable } from '../Observable';
import { async as asyncScheduler } from '../scheduler/async';
import { isScheduler } from '../util/isScheduler';
import { isValidDate } from '../util/isDate';
export function timer(dueTime = 0, periodOrScheduler, scheduler) {
    let period = -1;
    if (periodOrScheduler != null) {
        if (isScheduler(periodOrScheduler)) {
            scheduler = periodOrScheduler;
        }
        else {
            period = periodOrScheduler;
        }
    }
    if (!isScheduler(scheduler)) {
        scheduler = asyncScheduler;
    }
    return new Observable((subscriber) => {
        const due = Math.max(0, isValidDate(dueTime) ? +dueTime - scheduler.now() : dueTime);
        return scheduler.schedule(dispatch, due, {
            counter: 0,
            period,
            subscriber,
        });
    });
}
function dispatch(state) {
    const { period, subscriber } = state;
    const counter = state.counter++;
    subscriber.next(counter);
    if (!subscriber.closed) {
        if (period < 0) {
            return subscriber.complete();
        }
        this.schedule(state, period);
    }
}
//# sourceMappingURL=timer.js.map