import { Observable } from '../Observable';
import { Subscription } from '../Subscription';
import { from } from './from';
export function zip(...sources) {
    let resultSelector = undefined;
    if (typeof sources[sources.length - 1] === 'function') {
        resultSelector = sources.pop();
    }
    return new Observable((subscriber) => {
        const buffers = sources.map(() => []);
        const completed = sources.map(() => false);
        const subscription = new Subscription();
        const tryEmit = () => {
            if (buffers.every((buffer) => buffer.length > 0)) {
                let result = buffers.map((buffer) => buffer.shift());
                if (resultSelector) {
                    try {
                        result = resultSelector(...result);
                    }
                    catch (err) {
                        subscriber.error(err);
                        return;
                    }
                }
                subscriber.next(result);
                if (buffers.some((buffer, i) => buffer.length === 0 && completed[i])) {
                    subscriber.complete();
                }
            }
        };
        for (let i = 0; !subscriber.closed && i < sources.length; i++) {
            const source = from(sources[i]);
            subscription.add(source.subscribe({
                next: (value) => {
                    buffers[i].push(value);
                    tryEmit();
                },
                error: (err) => subscriber.error(err),
                complete: () => {
                    completed[i] = true;
                    if (buffers[i].length === 0) {
                        subscriber.complete();
                    }
                },
            }));
        }
        return subscription;
    });
}
//# sourceMappingURL=zip.js.map