import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function buffer(closingNotifier) {
    return operate((source, subscriber) => {
        let buffer = [];
        source.subscribe(new OperatorSubscriber(subscriber, (value) => buffer.push(value)));
        closingNotifier.subscribe(new OperatorSubscriber(subscriber, () => {
            const b = buffer;
            buffer = [];
            subscriber.next(b);
        }));
        return () => {
            buffer = null;
        };
    });
}
//# sourceMappingURL=buffer.js.map