import { combineLatestInit } from '../observable/combineLatest';
import { operate } from '../util/lift';
import { argsOrArgArray } from '../util/argsOrArgArray';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs';
import { pipe } from '../util/pipe';
export function combineLatest(...args) {
    let project = undefined;
    if (typeof args[args.length - 1] === 'function') {
        project = args.pop();
        return pipe(combineLatest(...args), mapOneOrManyArgs(project));
    }
    return operate((source, subscriber) => {
        return combineLatestInit([source, ...argsOrArgArray(args)])(subscriber);
    });
}
export function combineLatestWith(...otherSources) {
    return combineLatest(...otherSources);
}
//# sourceMappingURL=combineLatestWith.js.map