import { operate } from '../util/lift';
import { concatAll } from './concatAll';
import { fromArray } from '../observable/fromArray';
import { isScheduler } from '../util/isScheduler';
export function concatWith(...otherSources) {
    return concat(...otherSources);
}
export function concat(...args) {
    let scheduler;
    if (isScheduler(args[args.length - 1])) {
        scheduler = args.pop();
    }
    return operate((source, subscriber) => {
        concatAll()(fromArray([source, ...args], scheduler)).subscribe(subscriber);
    });
}
//# sourceMappingURL=concatWith.js.map