import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function count(predicate) {
    return operate((source, subscriber) => {
        let index = 0;
        let count = 0;
        source.subscribe(new OperatorSubscriber(subscriber, (value) => (!predicate || predicate(value, index++, source)) && count++, undefined, () => {
            subscriber.next(count);
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=count.js.map