import { asyncScheduler } from '../scheduler/async';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function debounceTime(dueTime, scheduler = asyncScheduler) {
    return operate((source, subscriber) => {
        let hasValue = false;
        let lastValue = null;
        let debounceSubscription = null;
        const emitLastValue = () => {
            hasValue = false;
            const value = lastValue;
            lastValue = null;
            subscriber.next(value);
        };
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            debounceSubscription === null || debounceSubscription === void 0 ? void 0 : debounceSubscription.unsubscribe();
            hasValue = true;
            lastValue = value;
            subscriber.add((debounceSubscription = scheduler.schedule(() => {
                debounceSubscription = null;
                emitLastValue();
            }, dueTime)));
        }, undefined, () => {
            hasValue && emitLastValue();
            subscriber.complete();
        }));
    });
}
//# sourceMappingURL=debounceTime.js.map