import { asyncScheduler } from '../scheduler/async';
import { isValidDate } from '../util/isDate';
import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
export function delay(delay, scheduler = asyncScheduler) {
    return operate((source, subscriber) => {
        const isAbsoluteDelay = isValidDate(delay);
        let isComplete = false;
        let active = 0;
        let absoluteTimeValues = isAbsoluteDelay ? [] : null;
        const checkComplete = () => isComplete && !active && !(absoluteTimeValues === null || absoluteTimeValues === void 0 ? void 0 : absoluteTimeValues.length) && subscriber.complete();
        if (isAbsoluteDelay) {
            active++;
            subscriber.add(scheduler.schedule(() => {
                active--;
                if (absoluteTimeValues) {
                    const values = absoluteTimeValues;
                    absoluteTimeValues = null;
                    for (const value of values) {
                        subscriber.next(value);
                    }
                }
                checkComplete();
            }, +delay - scheduler.now()));
        }
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            if (isAbsoluteDelay) {
                absoluteTimeValues ? absoluteTimeValues.push(value) : subscriber.next(value);
            }
            else {
                active++;
                subscriber.add(scheduler.schedule(() => {
                    active--;
                    subscriber.next(value);
                    checkComplete();
                }, delay));
            }
        }, undefined, () => {
            isComplete = true;
            checkComplete();
        }));
        return () => {
            absoluteTimeValues = null;
        };
    });
}
//# sourceMappingURL=delay.js.map