import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { concat } from '../observable/concat';
import { take } from './take';
import { ignoreElements } from './ignoreElements';
export function delayWhen(delayDurationSelector, subscriptionDelay) {
    if (subscriptionDelay) {
        return (source) => concat(subscriptionDelay.pipe(take(1), ignoreElements()), source.pipe(delayWhen(delayDurationSelector)));
    }
    return operate((source, subscriber) => {
        let index = 0;
        let isComplete = false;
        let active = 0;
        const checkComplete = () => isComplete && !active && subscriber.complete();
        source.subscribe(new OperatorSubscriber(subscriber, (value) => {
            let closed = false;
            const notify = () => {
                subscriber.next(value);
                durationSubscriber === null || durationSubscriber === void 0 ? void 0 : durationSubscriber.unsubscribe();
                if (!closed) {
                    active--;
                    closed = true;
                    checkComplete();
                }
            };
            const durationSubscriber = new OperatorSubscriber(subscriber, notify, undefined, notify);
            active++;
            delayDurationSelector(value, index++).subscribe(durationSubscriber);
        }, undefined, () => {
            isComplete = true;
            checkComplete();
        }));
    });
}
//# sourceMappingURL=delayWhen.js.map