import { operate } from '../util/lift';
import { OperatorSubscriber } from './OperatorSubscriber';
import { from } from '../observable/from';
export function expand(project, concurrent = Infinity, scheduler) {
    concurrent = (concurrent || 0) < 1 ? Infinity : concurrent;
    return operate((source, subscriber) => {
        let active = 0;
        let buffer = [];
        let index = 0;
        let isComplete = false;
        const emitAndExpand = (value) => {
            subscriber.next(value);
            const inner = from(project(value, index++));
            active++;
            const doSub = () => {
                inner.subscribe(new OperatorSubscriber(subscriber, next, undefined, () => {
                    --active === 0 && isComplete && !buffer.length ? subscriber.complete() : trySub();
                }));
            };
            scheduler ? subscriber.add(scheduler.schedule(doSub)) : doSub();
        };
        const trySub = () => {
            while (0 < buffer.length && active < concurrent) {
                emitAndExpand(buffer.shift());
            }
        };
        const next = (value) => (active < concurrent ? emitAndExpand(value) : buffer.push(value));
        source.subscribe(new OperatorSubscriber(subscriber, next, undefined, () => {
            isComplete = true;
            active === 0 && subscriber.complete();
        }));
        return () => {
            buffer = null;
        };
    });
}
//# sourceMappingURL=expand.js.map